<?php

get_header();

 $link_audio = get_post_meta(get_the_ID(),'_cmb_link_audio', true);
 $link_video = get_post_meta(get_the_ID(),'_cmb_link_video', true);
?>
<!-- SUBHEADER -->
<section id="subheader" data-speed="8" data-type="background" class="subheader padding-top-bottom" 
  <?php if( function_exists( 'rwmb_meta' ) ) { ?>       
  <?php $images = rwmb_meta( '_cmb_bg_header', "type=image" ); ?>
      <?php if($images){ foreach ( $images as $image ) { ?>
      <?php $img =  $image['full_url']; ?>
        style="background-image: url('<?php echo esc_url($img); ?>');"
      <?php } } ?>
  <?php } ?>
>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1><?php //echo esc_html_e('Single Blog', 'compact') ?></h1>
                <?php if($compact_option['breadcrumbs'] == true){ ?>
                    <?php compact_breadcrumbs(); ?>
                <?php } ?>       
            </div>
        </div>
    </div>
</section>
<!-- END OF SUBHEADER -->

<?php while (have_posts()) : the_post(); ?>
<!-- content begin -->

<div id="content">
  <div class="container">
      <div class="row"> 
          <div class="col-md-9">
            <div class="blog-single">
              <article>
                <?php $format = get_post_format(); ?>
                <?php if($format=='video') { ?>

                <div class="embed-responsive embed-responsive-16by9">
                  <iframe style="width:100%" height="500px" src="<?php echo esc_url( $link_video ); ?>"></iframe>
                </div>

                <?php }elseif($format=='audio') {?>

                <iframe style="width:100%" src="<?php echo esc_url($link_audio); ?>"></iframe>

                <?php }elseif($format=='gallery'){ ?>
                  <?php
                    if ( function_exists('rwmb_meta') ) { 
                  ?>  
                  <?php $images = rwmb_meta( '_cmb_images', "type=image" ); ?>
                  <?php if($images){ ?>
                    <div class="project-slider">
                      <?php                                                        
                        foreach ( $images as $image ) {                              
                      ?>
                      <?php $img = $image['full_url']; ?>
                        <div class="item"><img src="<?php echo esc_url($img); ?>" alt=""></div> 
                      <?php } ?>                   
                      </div>
                  <?php } ?>
                <?php } ?>
  
                <?php }elseif($format=='image'){ ?>
                  <?php
                    if ( function_exists('rwmb_meta') ) { 
                  ?>
                    <?php $images = rwmb_meta( '_cmb_image', "type=image" ); ?>
                    <?php if($images){ ?>
                    <?php                                                        
                      foreach ( $images as $image ) {                              
                      ?>
                      <?php $img = $image['full_url']; ?>
                      <div class="post-media">
                        <img src="<?php echo esc_url($img); ?>" alt="" class="img-responsive">
                      </div>
                      <?php } ?>
                    <?php } ?>
                  <?php } ?>

                <?php }else{ ?>
                  <?php if(has_post_thumbnail()) { ?><div class="post-media"><img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" class="img-responsive" alt="" /></div><?php } ?>
                <?php } ?>
                <div class="post-content single-post-content">
                  <div class="post-title">
                      <h1><?php the_title(); ?></h1>
                  </div>
                  <div class="post-metadata">                                                              
                      <?php compact_entry_meta(); ?>    
                  </div>
                <div class="hr"></div>
                <div class="post-entry">
                <?php the_content(); ?>
                <?php
                    wp_link_pages( array(
                        'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'compact' ) . '</span>',
                        'after'       => '</div>',
                        'link_before' => '<span>',
                        'link_after'  => '</span>',
                        'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'compact' ) . ' </span>%',
                        'separator'   => '<span class="screen-reader-text">, </span>',
                    ) );
                ?>
                </div>
                <div class="footer-entry clearfix">
                    <?php if(has_tag()) { ?>
                      <div class="single-tags pull-left">
                          <i class="fa fa-tags"></i>
                          <?php the_tags( '', ', ', '' ); ?>
                      </div>
                    <?php } ?>
                    <?php if($compact_option['social_share'] == true){ ?>
                    <div class="social-share pull-right">
                      <a class="facebook" target="_blank" href="https://facebook.com/home?status=<?php the_permalink(); ?>"><i class="icons fa fa-facebook"></i></a>                  
                      <a class="twitter" target="_blank" href="https://twitter.com/home?status=<?php the_permalink(); ?>"><i class="icons fa fa-twitter"></i></a>                    
                      <a class="google" target="_blank" href="https://plus.google.com/home?status=<?php the_permalink(); ?>"><i class="icons fa fa-google-plus"></i></a>                    
                      <a class="linkedin" target="_blank" href="https://linkedin.com/home?status=<?php the_permalink(); ?>"><i class="icons fa fa-linkedin"></i></a>                    
                    </div>
                    <?php } ?>
                </div>
              
              <nav class="navigation post-navigation">                                        
                  <div class="nav-links">
                      <div class="nav-previous">
                          <?php previous_post_link( '%link', _x( '<span class="meta-nav"><i class="fa fa-angle-double-left"></i> Previous</span> <span class="post-title"> %title </span>', 'Previous post link', 'compact' ) ); ?>
                      </div>
                      <div class="nav-next">
                          <?php next_post_link( '%link', _x( '<span class="meta-nav"> Next <i class="fa fa-angle-double-right"></i></span><span class="post-title"> %title</span>', 'Next post link', 'compact' ) ); ?>
                      </div>
                  </div>
              </nav>
              <div class="clearfix"></div>
              <div class="comments-area" id="comments">
              
              <?php
               if ( comments_open() || get_comments_number() ) :
                comments_template();
               endif;
              ?>
              </div>
              </article>
            </div>
            </div>  
            <div class="col-md-3">
              <div class="main-sidebar">
                <?php get_sidebar();?>
              </div>
            </div>
        </div>
      </div>
    </div>
 </div>

<?php endwhile;?>
  <!-- END CONTENT BLOG -->
<?php get_footer(); ?>	





  