<?php
global $compact_option;
get_header(); ?>

<section id="subheader" data-speed="8" data-type="background" class="subheader padding-top-bottom" <?php if($compact_option['bg_portfolio'] != ''){ ?> style="background-image:url(<?php echo esc_url($compact_option['bg_portfolio']['url']); ?>)"<?php } ?>>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1><?php echo esc_html_e('Portfolio Details','compact'); ?></h1>
                <?php if($compact_option['breadcrumbs'] == true){ ?>
                    <?php compact_breadcrumbs(); ?> 
                <?php } ?>         
            </div>
        </div>
    </div>
</section>
	
<?php while (have_posts()) : the_post()?>
	<?php the_content(); ?>
<?php endwhile; ?>

<!-- Related Project begin -->
<section id="section-related-project" class="no-padding-top">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="latest-projects-2 clearfix">                                
                    <div class="latest-projects-wrapper">
                        <div class="text-center">
                            <h2 class="box-title"><?php esc_html_e('Related Projects', 'compact'); ?></h2>                                
                            <div class="tiny-border"></div>
                        </div>
                        <div id="related-projects" class="latest-projects-items">

                            <!-- begin custom related loop -->
 
                            <?php 
                            global $post;
                            $current_post_type = get_post_type( $post );
                            $args = array(
                                'order' => 'DESC',
                                'orderby' => 'rand',
                                'post_type' => $current_post_type,
                                'post__not_in' => array( $post->ID ),
                                'posts_per_page' => 7,
                            );
                            $related_items = new WP_Query( $args );
                            // loop over query
                            if ($related_items->have_posts()) : while ( $related_items->have_posts() ) : $related_items->the_post(); ?>
                                
                                <div class="item">
                                    <?php the_post_thumbnail( 'portfolio_thumbnail', array( 'class' => 'img-responsive' ) ); ?>                                    
                                    <div class="project-details">
                                        <p class="folio-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
                                        <p class="folio-cate"><i class="fa fa-tag"></i>
                                        <?php             
                                            $terms = get_the_terms(get_the_ID(),'categories');
                                            //echo '<ul>';
                                            foreach ( $terms as $term ) {                               
                                                // The $term is an object, so we don't need to specify the $taxonomy.
                                                $term_link = get_term_link( $term );
                                               
                                                // If there was an error, continue to the next term.
                                                if ( is_wp_error( $term_link ) ) {
                                                    continue;
                                                }

                                                // We successfully got a link. Print it out.                
                                                echo '<a href="' . esc_url( $term_link ) . '">' . $term->name . '</a><span>,</span> ';
                                            }

                                            //echo '</ul>';
                                          ?>
                                        </p>
                                        <div class="folio-buttons">
                                            <a href="<?php echo esc_url(wp_get_attachment_url(get_post_thumbnail_id())); ?>" title="<?php the_title(); ?>" class="folio"><i class="fa fa-search"></i></a>
                                            <a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i></a>
                                        </div>
                                    </div>
                                </div>
                            
                            <?php endwhile; endif; wp_reset_postdata();?>
                            <!-- end custom related loop -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>     
</section>
<!-- Related Project close -->
	
<?php get_footer(); ?>