<?php

get_header();
global $compact_option;
?>
<section id="subheader" data-speed="8" data-type="background" class="subheader padding-top-bottom" <?php if($compact_option['bg_blog'] != ''){ ?> style="background-image:url(<?php echo esc_url($compact_option['bg_blog']['url']); ?>)"<?php } ?>>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1><?php printf( esc_html__( 'Search results for: %s', 'compact' ), get_search_query() ); ?></h1>
                <?php if($compact_option['breadcrumbs'] == true){ ?>
                <ul class="breadcrumbs">
                    <?php compact_breadcrumbs(); ?>
                </ul>            
                <?php } ?>
            </div>
        </div>
    </div>
</section>

<div id="content">
    <div class="container">
        <div class="row"> 
            <div class="col-md-9">
                <div class="blog-list">

                <?php if(have_posts()) :

                    while ( have_posts()): the_post();                        

                    get_template_part( 'content', get_post_format() ) ;

                    endwhile;?>

                    <?php // If no content, include the "No posts found" template.
                    else : ?>
                        <section class="no-results not-found">                            
                            <h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'compact' ); ?></h1>
                            
                            <div class="page-content">
                                <p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'compact' ); ?></p>
                                <div class="widget_search">
                                    <?php get_search_form(); ?>
                                </div>
                            </div><!-- .page-content -->
                        </section><!-- .no-results -->
                    <?php endif; ?>
                </div>
                <div class="pagination-ourter text-center">
                    <ul class="pagination">
                        <?php echo compact_pagination(); ?>
                    </ul>
                </div>

            </div>

            <div class="col-md-3">
                <div class="main-sidebar">
                    <?php get_sidebar();?>
                </div>
            </div>
        </div>
    </div>
</div>  
<!-- content close -->
<?php get_footer(); ?>