<?php
/*
 * Template Name: FullWidth
 * Description: A Page Template with a Page Builder design.
 */
get_header(); ?>

    <section id="subheader" data-speed="8" data-type="background" class="padding-top-bottom subheader" 
        <?php if( function_exists( 'rwmb_meta' ) ) { ?>       
        <?php $images = rwmb_meta( '_cmb_bg_header', "type=image" ); ?>
            <?php if($images){ foreach ( $images as $image ) { ?>
            <?php $img =  $image['full_url']; ?>
              style="background-image: url('<?php echo esc_url($img); ?>');"
            <?php } } ?>
        <?php } ?>
    >
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h1><?php the_title(); ?></h1>
                    <?php if($compact_option['breadcrumbs'] == true){ ?>                    
                        <?php compact_breadcrumbs(); ?>                        
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>

    <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
		<?php the_content(); ?>
	<?php endwhile; else : ?>
        <p><?php esc_html_e( 'Sorry, no posts matched your criteria.', 'compact' ); ?></p>
    <?php endif; ?>

<?php get_footer(); ?>