<?php

/**
 * Template Name: Blog List
 */

get_header();

?>

<section id="subheader" data-speed="8" data-type="background" class="subheader padding-top-bottom" 
    <?php if( function_exists( 'rwmb_meta' ) ) { ?>       
    <?php $images = rwmb_meta( '_cmb_bg_header', "type=image" ); ?>
        <?php if($images){ foreach ( $images as $image ) { ?>
        <?php $img =  $image['full_url']; ?>
          style="background-image: url('<?php echo esc_url($img); ?>');"
        <?php } } ?>
    <?php } ?>
>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1><?php echo esc_html_e('Blog List', 'compact') ?></h1>
                <?php if($compact_option['breadcrumbs'] ==true){ ?>
                    <?php compact_breadcrumbs(); ?>
                <?php } ?>    
            </div>
        </div>
    </div>
</section>
<!--  END OF HEADER -->

<div id="content">
    <div class="container">
        <div class="row"> 
            <div class="col-md-9">
                <div class="blog-list">
                <?php if(have_posts()) : ?>  
                    <?php 
                    $args = array(    
                      'paged' => $paged,
                      'post_type' => 'post',
                    );
                    $wp_query = new WP_Query($args);
                    while ($wp_query -> have_posts()): $wp_query -> the_post();                        
                    get_template_part( 'content', get_post_format() ) ;
                    endwhile;?>
                    <?php else: ?>
                    <h1><?php esc_html_e('Nothing Found Here!', 'compact'); ?></h1>
                <?php endif ?>
                </div>

                <div class="pagination-ourter text-center">
                    <ul class="pagination">
                        <?php echo compact_pagination(); ?>
                    </ul>
                </div>
            </div>

            <div class="col-md-3">
                <div class="main-sidebar">
                    <?php get_sidebar();?>
                </div>
            </div>
        </div>
    </div>   
</div>
<!-- content close -->
<?php get_footer(); ?>