<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8 no-js lt-ie9" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8) ]><!-->
<html <?php language_attributes(); ?>>
<?php global $compact_option; ?>
<!--<![endif]-->
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="SKYPE_TOOLBAR" content="SKYPE_TOOLBAR_PARSER_COMPATIBLE" />

    <!-- Page Title 
    ================================================== -->
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

    <?php compact_custom_favicon(); ?>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php if($compact_option['preload-switch'] == true){ ?>
        <!-- Preload images start //-->
        <div class="images-preloader" id="images-preloader">
          <div class="spinner">
              <div class="bounce1"></div>
              <div class="bounce2"></div>
              <div class="bounce3"></div>
          </div>
        </div>
        <!-- Preload images end //-->
    <?php } ?>

    <div id="wrapper">
    <?php 
        if(isset($compact_option['header_layout']) and $compact_option['header_layout'] == "header2" ){
            get_template_part('framework/headers/header-2'); 
        }elseif(isset($compact_option['header_layout']) and $compact_option['header_layout'] == "header3" ){
            get_template_part('framework/headers/header-3');   
        }else{
    ?>
    <header class="site-header-1 site-header">
        <div id="sticked-menu" class="main-bar">
          <div class="container">                
            <div class="row">                    
              <div class="col-md-12">

                <!-- logo begin -->
                <?php if($compact_option['logo']['url'] !=''){ ?>
                    <div id="logo" class="pull-left">                            
                        <a href="<?php echo esc_url( home_url('/') ); ?>">
                            <img src="<?php echo esc_url($compact_option['logo']['url']); ?>" alt="" class="logo" />
                        </a>
                    </div>
                <?php } ?>
                <!-- logo close -->

                <!-- btn-mobile menu begin -->
                <a id="show-mobile-menu" class="btn-mobile-menu hidden-lg hidden-md"><i class="fa fa-bars"></i></a>
                <!-- btn-mobile menu close -->  

                <!-- mobile menu begin -->
                <nav id="mobile-menu" class="site-mobile-menu hidden-lg hidden-md">
                    <ul></ul>
                </nav>  
                <!-- mobile menu close -->  

                <!-- desktop menu begin --> 
                <nav id="desktop-menu" class="site-desktop-menu hidden-xs hidden-sm">
                    <?php
                        $topmenu = array(
                            'theme_location'  => 'primary',
                            'menu'            => '',
                            'container'       => '',
                            'container_class' => '',
                            'container_id'    => '',
                            'menu_class'      => 'clearfix',
                            'menu_id'         => '',
                            'echo'            => true,
                            'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                            'walker'          => new wp_bootstrap_navwalker(),
                            'before'          => '',
                            'after'           => '',
                            'link_before'     => '',
                            'link_after'      => '',
                            'items_wrap'      => '<ul data-breakpoint="800" id="%1$s" class="%2$s">%3$s</ul>',
                            'depth'           => 0,
                        );
                        if ( has_nav_menu( 'primary' ) ) {
                            wp_nav_menu( $topmenu );
                        }
                    ?>
                </nav>
                <div class="header-buttons pull-right hidden-xs hidden-sm">
                    <?php if($compact_option['header_infos'] != ''){ ?>
                        <div class="header-contact">
                            <?php echo wp_kses( $compact_option['header_infos'], wp_kses_allowed_html('post') ); ?>
                        </div>
                    <?php } ?>
                    
                    <?php if($compact_option['search_head'] == true){ ?>
                        <!-- Button Modal popup searchbox -->
                        <div class="search-button">
                        <!-- Trigger the modal with a button -->
                            <a href="" data-toggle="modal" data-target="#myModal"><i class="fa fa-search"></i></a>                                                                        
                        </div>
                    <?php } ?>

                    <?php if (class_exists('Woocommerce')) { ?>
                        <!-- Top Cart -->
                        <div class="cart-button">
                            <a href="#" class="dropdown-toggle cart-contents" data-toggle="dropdown" ><i class="fa fa-shopping-bag"></i> <span class="mini-cart-counter">0</span></a>
                            <div class="dropdown-menu top_cart_list_product">
                                <?php the_widget( 'WC_Widget_Cart', 'title=' ); ?>
                            </div>
                        </div>
                    <?php } ?>
                                                
                    <?php if($compact_option['menu_right'] == true){ ?>
                        <!-- Button Menu OffCanvas right -->
                        <div class="navright-button">
                            <a href="" id="btn-offcanvas-menu"><i class="fa fa-bars"></i></a>                                    
                        </div> 
                    <?php } ?>
                </div>
              </div>
            </div>
          </div>
        </div>
    </header>
    <div class="gray-line"></div>   
    
    <?php if($compact_option['search_head'] == true){ ?>  
        <!-- Header Group Button Right close -->
        <div id="myModal" class="modal fade" role="dialog">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <div class="modal-dialog myModal-search">
            <!-- Modal content-->
            <div class="modal-content">                                        
                <div class="modal-body">
                    <?php get_search_form(); ?>
                </div>
            </div>
          </div>
        </div>
        <!-- Modal Search close -->
    <?php } ?>

    <!-- Menu OffCanvas right begin -->
    <?php if($compact_option['menu_right'] == true){ ?>
        <div class="navright-button hidden-sm">
            <div class="compact-menu-canvas" id="offcanvas-menu">
                <?php if($compact_option['title_menu_right']!= ''){ ?><h3><?php echo esc_attr($compact_option['title_menu_right']); ?><?php } ?></h3><a id="btn-close-canvasmenu"><i class="fa fa-close"></i></a>
                <nav>
                <?php
                    $topmenu = array(
                        'theme_location'  => 'other',
                        'menu'            => '',
                        'container'       => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'menu_class'      => 'clearfix',
                        'menu_id'         => '',
                        'echo'            => true,
                        'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                        'walker'          => new wp_bootstrap_navwalker(),
                        'before'          => '',
                        'after'           => '',
                        'link_before'     => '',
                        'link_after'      => '',
                        'items_wrap'      => '<ul data-breakpoint="800" id="%1$s" class="%2$s">%3$s</ul>',
                        'depth'           => 0,
                    );
                    if ( has_nav_menu( 'other' ) ) {
                        wp_nav_menu( $topmenu );
                    }
                ?>                
                </nav>
            </div>
        </div> 
    <?php } ?>
    <!-- Menu OffCanvas right close -->
<?php } ?> 