<?php
if ( ! class_exists( 'ReduxFramewrk' ) ) {
    require get_template_directory() . '/framework/sample-config.php';
  function removeDemoModeLink() { // Be sure to rename this function to something more unique
    if ( class_exists('ReduxFrameworkPlugin') ) {
      remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
    }
    if ( class_exists('ReduxFrameworkPlugin') ) {
      remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
  }
  add_action('init', 'removeDemoModeLink');
}

if ( ! function_exists( 'compact_theme_setup' ) ) :

function compact_theme_setup() {

   /*
     * Make theme available for translation.
     * Translations can be filed in the /languages/ directory.
     * If you're building a theme based on cubic, use a find and replace
     * to change 'cubic' to the name of your theme in all the template files
     */

    load_theme_textdomain( 'compact', get_template_directory() . '/languages' );

    /** Set Content width **/
    if ( ! isset( $content_width ) ) 
        $content_width = 900;
    /*
     * This theme uses a custom image size for featured images, displayed on
     * "standard" posts and pages.
     */
	  add_theme_support( 'custom-header' ); 
	  add_theme_support( 'custom-background' );
    add_theme_support( 'post-thumbnails' );
    // Adds RSS feed links to <head> for posts and comments.
    add_theme_support( 'automatic-feed-links' );

    // Switches default core markup for search form, comment form, and comments
    // to output valid HTML5.
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );

    //Post formats
    add_theme_support( 'post-formats', array(
        'audio',  'gallery', 'image', 'video',
    ) );

    //Tags
    add_theme_support( 'title-tag' );

    // This theme uses wp_nav_menu() in one location.
  	register_nav_menus( array(
          'primary'   => esc_html__('Primary Menu', 'compact'),
          'other'     => esc_html__('Other Menu', 'compact'),
  	) );
}
endif;
add_action( 'after_setup_theme', 'compact_theme_setup' );

/*Register Fonts*/
function compact_fonts_url() {
    $fonts_url = '';
    $raleway = _x( 'on', 'Raleway font: on or off', 'compact' );
    $droid = _x( 'on', 'Droid font: on or off', 'compact' );
    $lato = _x( 'on', 'Lato font: on or off', 'compact' );

    if ( 'off' !== $raleway || 'off' !== $droid || 'off' !== $lato ) {
        $font_families = array();
 
        if ( 'off' !== $raleway ) {
            $font_families[] = 'Raleway:400,100italic,100,200italic,200,300,300italic,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic';
        }

        if ( 'off' !== $droid ) {
            $font_families[] = 'Droid+Serif:400,400italic,700,700italic';
        }
 
        if ( 'off' !== $lato ) {
            $font_families[] = 'Lato:400,100,100italic,300,300italic,400italic,700,700italic,900,900italic';
        }
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );
 
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }

    return esc_url_raw( $fonts_url );
}

function compact_theme_scripts_styles() {
  global $compact_option;
  $gmapapi = $compact_option['gmap_api'];
	$protocol = is_ssl() ? 'https' : 'http';

  /** All frontend css files **/
  wp_enqueue_style( 'compact-fonts', compact_fonts_url(), array(), null );

  wp_enqueue_style( 'compact-bootstrap', get_template_directory_uri().'/css/bootstrap.css');
  wp_enqueue_style( 'compact-font-awesome', get_template_directory_uri().'/fonts/font-awesome/css/font-awesome.css');    
  wp_enqueue_style( 'compact-carousel', get_template_directory_uri().'/css/owl.carousel.css');
  wp_enqueue_style( 'compact-owl.theme', get_template_directory_uri().'/css/owl.theme.css');
  wp_enqueue_style( 'compact-animate', get_template_directory_uri().'/css/animate.min.css');
  wp_enqueue_style( 'compact-magnific-popup', get_template_directory_uri().'/css/magnific-popup.css');
  wp_enqueue_style( 'compact-bg-image', get_template_directory_uri().'/css/bg-image.css');
  wp_enqueue_style( 'compact-rev-settings', get_template_directory_uri().'/css/rev-settings.css');  
  wp_enqueue_style( 'compact-countdown', get_template_directory_uri().'/css/jquery.countdown.css');
  wp_enqueue_style( 'compact-woocommerce', get_template_directory_uri().'/css/woocommerce.css');    
  wp_enqueue_style( 'compact-style', get_stylesheet_uri(), array(), '21-05-2015' );    
		
  /** Js for comment on single post **/    
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ){
    wp_enqueue_script( 'comment-reply' );
	}

  /** All frontend js files **/
  wp_enqueue_script("compact-bootstrap", get_template_directory_uri()."/js/bootstrap.min.js",array('jquery'),false,true);
	wp_enqueue_script("compact-easing", get_template_directory_uri()."/js/easing.js",array('jquery'),false,true);
  wp_enqueue_script("compact-carousel", get_template_directory_uri()."/js/owl.carousel.js",array('jquery'),false,true);
  wp_enqueue_script("compact-fitvids", get_template_directory_uri()."/js/jquery.fitvids.js",array('jquery'),false,true);

  if($compact_option['animate-switch']!=false){
    wp_enqueue_script("compact-wow", get_template_directory_uri()."/js/wow.min.js",array('jquery'),false,true);
  }

	wp_enqueue_script("compact-magnific-popup", get_template_directory_uri()."/js/jquery.magnific-popup.min.js",array('jquery'),false,true);
  wp_enqueue_script("compact-waypoints", get_template_directory_uri()."/js/jquery.waypoints.min.js",array('jquery'),false,true);
	wp_enqueue_script("compact-visible", get_template_directory_uri()."/js/visible.min.js",array('jquery'),false,true);
  wp_enqueue_script("compact-sticky", get_template_directory_uri()."/js/sticky.min.js",array('jquery'),false,true);
  wp_enqueue_script("compact-isotope", get_template_directory_uri()."/js/jquery.isotope.min.js",array('jquery'),false,true);
  wp_enqueue_script("compact-maps-js", "$protocol://maps.googleapis.com/maps/api/js?key=$gmapapi",array('jquery'),false,true);
  wp_enqueue_script("compact-imagesloaded", get_template_directory_uri()."/js/imagesloaded.pkgd.min.js",array('jquery'),false,true);
  wp_enqueue_script("compact-masonry", get_template_directory_uri()."/js/masonry.js",array('jquery'),false,true);
  wp_enqueue_script("compact-tipper", get_template_directory_uri()."/js/tipper.js",array('jquery'),false,true);
  wp_enqueue_script("compact-stellar", get_template_directory_uri()."/js/jquery.stellar.js",array('jquery'),false,true);
  wp_enqueue_script("compact-script", get_template_directory_uri()."/js/compact.js",array('jquery'),false,true);
  
}
add_action( 'wp_enqueue_scripts', 'compact_theme_scripts_styles');

if(!function_exists('compact_custom_frontend_style')){
  function compact_custom_frontend_style(){
      global $compact_option;
      echo '<style type="text/css">'.$compact_option['custom-css'].'</style>';
    }
}
add_action('wp_head', 'compact_custom_frontend_style');

// Widget Sidebar
function compact_widgets_init() {
	register_sidebar( array(
    'name'          => esc_html__( 'Primary Sidebar', 'compact' ),
    'id'            => 'sidebar-1',        
		'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'compact' ),        
		'before_widget' => '<div id="%1$s" class="widget %2$s">',        
		'after_widget'  => '</div>',        
		'before_title'  => '<h3 class="widget-title">',        
		'after_title'   => '</h3><div class="tiny-border"></div>'
    ) );

  register_sidebar( array(
    'name'          => esc_html__( 'Shop Sidebar', 'compact' ),
    'id'            => 'shop-sidebar',        
    'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'compact' ),        
    'before_widget' => '<div id="%1$s" class="widget %2$s">',        
    'after_widget'  => '</div>',        
    'before_title'  => '<h3 class="widget-title">',        
    'after_title'   => '</h3><div class="tiny-border"></div>'
    ) );
  register_sidebar( array(
		'name'          => esc_html__( 'Footer One Widget Area', 'compact' ),
		'id'            => 'footer-area-1',
		'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'compact' ),
		'before_widget' => '<div id="%1$s" class="compact-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Two Widget Area', 'compact' ),
		'id'            => 'footer-area-2',
		'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'compact' ),
		'before_widget' => '<div id="%1$s" class="compact-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Three Widget Area', 'compact' ),
		'id'            => 'footer-area-3',
		'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'compact' ),
		'before_widget' => '<div id="%1$s" class="compact-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Fourth Widget Area', 'compact' ),
		'id'            => 'footer-area-4',
		'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'compact' ),
		'before_widget' => '<div id="%1$s" class="compact-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );    
 
}
add_action( 'widgets_init', 'compact_widgets_init' );

//Code Visual Compurso.
// Add new Param in Row
if(function_exists('vc_add_param')){
  vc_add_param(
    'vc_row',
    array(
      "type" => "dropdown",
      "heading" => esc_html__('Setup Full width For Row', 'compact'),
      "param_name" => "fullwidth",
      "value" => array(   
                        esc_html__('No', 'compact') => 'no',  
                        esc_html__('Yes', 'compact') => 'yes',                                                                                
                      ),
      "description" => esc_html__("Select Full width for row : yes or not, Default: No fullwidth", "compact"),      
    ) 
  );

  vc_add_param(
    'vc_row',
    array(
        'type' => 'checkbox',
        'heading' => esc_html__( 'Parallax background for row?', 'compact' ),
        'param_name' => 'bg_parallax_section',
        'description' => esc_html__( 'Add parallax type background for row (Note: If no image is specified, parallax will use background image from Design Options).', 'compact' ),
        'value' => array( esc_html__( 'Yes', 'compact' ) => 'yes' ),
    )
  );
  vc_add_param(
    'vc_row',
    array(
        'type' => 'attach_image',
        'heading' => esc_html__( 'Image', 'compact' ),
        'param_name' => 'parallax_image_section',
        'value' => '',
        'description' => esc_html__( 'Select image from media library.', 'compact' ),
        'dependency' => array(
          'element' => 'bg_parallax_section',
          'not_empty' => true,
      ),
    )
  );
  vc_add_param(
    'vc_row',
    array(
        "type" => "textfield",
        "heading" => esc_html__('Parallax speed', 'compact'),
        "param_name" => "parallax_speed_section",
        "value" => ".5",
        "description" => esc_html__("Enter parallax speed ratio (Note: Default value is .5, min value is .5)", 'compact'), 
        'dependency' => array(
          'element' => 'bg_parallax_section',
          'not_empty' => true,
      ),
    ) 
  );

  // Add new Param in Column  
  vc_add_param('vc_column',array(
      "type" => "dropdown",
      "heading" => esc_html__('Animate Column', 'compact'),
      "param_name" => "animate",
      "value" => array(   
              esc_html__('None', 'compact') => 'none',              
              esc_html__('Fade In', 'compact') => 'fadein', 
              esc_html__('Fade In Up', 'compact') => 'fadeinup',
              esc_html__('Fade In Down', 'compact') => 'fadeindown',              
              esc_html__('Fade In Left', 'compact') => 'fadeinleft',  
              esc_html__('Fade In Right', 'compact') => 'fadeinright',
              esc_html__('Slide In Up', 'compact') => 'slideinup',
              esc_html__('Slide In Down', 'compact') => 'slideindown',              
              esc_html__('Slide In Left', 'compact') => 'slideinleft',  
              esc_html__('Slide In Right', 'compact') => 'slideinright',
              esc_html__('Zoom In', 'compact') => 'zoomin',
              esc_html__('Zoom In Down', 'compact') => 'zoomindown',
              esc_html__('Zoom In Left', 'compact') => 'zoominleft',
              esc_html__('Zoom In Right', 'compact') => 'zoominright',
              esc_html__('Zoom In Up', 'compact') => 'zoominup', 
              ),
      "description" => esc_html__("Select Animate , Default: None", 'compact'),      
    ) 
  );
  vc_add_param('vc_column',array(
      "type" => "textfield",
      "heading" => esc_html__('Animate duration number.', 'compact'),
      "param_name" => "animate_duration",
      "value" => "",
      "description" => esc_html__("Example : 0.2, 0.6, 1, etc", 'compact'),   
      "dependency"  => array( 'element' => 'animate', 'value' => array( 'fadeinup', 'fadeindown', 'fadein', 'fadeinleft', 'fadeinright', 'slideinup', 'slideindown', 'slideinleft', 'slideinright', 'zoomin', 'zoomindown', 'zoominleft', 'zoominright', 'zoominup') ),   
    ) 
  );
  vc_add_param('vc_column',array(
      "type" => "textfield",
      "heading" => esc_html__('Animate delay number.', 'compact'),
      "param_name" => "animate_delay",
      "value" => "",
      "description" => esc_html__("Example : 0.2, 0.6, 1, etc", 'compact'), 
      "dependency"  => array( 'element' => 'animate', 'value' => array( 'fadeinup', 'fadeindown', 'fadein', 'fadeinleft', 'fadeinright', 'slideinup', 'slideindown', 'slideinleft', 'slideinright', 'zoomin', 'zoomindown', 'zoominleft', 'zoominright', 'zoominup') ),       
    ) 
  );  


  vc_remove_param( "vc_row", "parallax" );
  vc_remove_param( "vc_row", "parallax_image" );
  vc_remove_param( "vc_row", "parallax_speed_bg" );
  vc_remove_param( "vc_row", "parallax_speed_video" );
  vc_remove_param( "vc_row", "full_width" );
  vc_remove_param( "vc_row", "full_height" );
  vc_remove_param( "vc_row", "video_bg" );
  vc_remove_param( "vc_row", "video_bg_parallax" );
  vc_remove_param( "vc_row", "content_placement" );
  vc_remove_param( "vc_row", "video_bg_url" );
  vc_remove_param( "vc_row", "columns_placement" );
  vc_remove_param( "vc_row", "gap" );
  vc_remove_param( "vc_row", "equal_height" );
  vc_remove_element( "vc_basic_grid" );
  vc_remove_element( "vc_masonry_grid" );
  vc_remove_element( "vc_media_grid" );
  vc_remove_element( "vc_masonry_media_grid" );
}
//}

/**
 * Implement the Custom Meta Boxs.
 */
require get_template_directory() . '/framework/meta-boxes.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/framework/template-tags.php';

/**
 * Customizer Menu.
 */
require get_template_directory() . '/framework/wp_bootstrap_navwalker.php';

/**
 * Custom woocommerce for this theme.
 */
require get_template_directory() . '/framework/woocommerce-customize.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/framework/customizer.php';

/**
 * Require plugins install for this theme.
 *
 * @since Compact 1.0
 */
require get_template_directory() . '/framework/class-tgm-plugin-activation.php';
require get_template_directory() . '/framework/plugin-requires.php';

?>