<?php 
/**** WooCommerce custom functions ****/

if (class_exists('Woocommerce')) {
	
    add_action( 'after_setup_theme', 'compact_woocommerce_support' );
	function compact_woocommerce_support() {
	    add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
	}    

    /**
	 * Products per page, display 12 products per page.
	 *
	 * @return integer number of products.
	 */
	function compact_woocommerce_products_per_page() {
		return 12;
	}
	add_filter( 'loop_shop_per_page', 'compact_woocommerce_products_per_page' );

    // breadcrumb woocommerce
    remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );

    // Remove link before and after product
    remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
    remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );

    if (  ! function_exists( 'woocommerce_template_loop_product_title' ) ) {
        /**
         * Show the product title in the product loop. By default this is an H3.
         */
        function woocommerce_template_loop_product_title() {
            echo '<h3>' . get_the_title() . '</h3>';
        }
    }

	add_filter( 'woocommerce_output_related_products_args', 'compact_related_products_args' );
	function compact_related_products_args( $args ) {
		$args['posts_per_page'] = 3; // 4 related products
		$args['columns'] = 3; // arranged in 2 columns
		return $args;
	}

	// Ensure cart contents update when products are added to the cart via AJAX (place the following in functions.php)
	add_filter( 'woocommerce_add_to_cart_fragments', 'compact_header_add_to_cart_fragment' );
	function compact_header_add_to_cart_fragment( $fragments ) {
		ob_start();
		global $compact_option;
		if(isset($compact_option['header_layout']) and $compact_option['header_layout'] == "header3" ){
		?>
			<a href="<?php echo WC()->cart->get_cart_url(); ?>" class="cart-contents" title="<?php esc_html_e( 'View your shopping cart', 'compact' ); ?>"><i class="fa fa-shopping-bag"></i> <span class="mini-cart-counter"><?php echo WC()->cart->get_cart_contents_count(); ?></span></a>	
		<?php }else{ ?>
			<a href="<?php echo WC()->cart->get_cart_url(); ?>" class="dropdown-toggle cart-contents" data-toggle="dropdown" title="<?php esc_html_e( 'View your shopping cart', 'compact' ); ?>"><i class="fa fa-shopping-bag"></i> <span class="mini-cart-counter"><?php echo WC()->cart->get_cart_contents_count(); ?></span></a>	
        <?php }	?>
	<?php
		$fragments['a.cart-contents'] = ob_get_clean();
		return $fragments;
	}

}
?>