<?php global $compact_option; ?>
<header class="site-header-3 site-header">
  <!-- Main bar start -->
  <div id="sticked-menu" class="main-bar">
    <div class="container">                
      <div class="row">                    
        <div class="col-md-12">

            <!-- logo begin -->
            <?php if($compact_option['logo'] != '') { ?>
                <div id="logo" class="pull-left">                            
                    <a href="<?php echo esc_url( home_url('/') ); ?>">
                        <img src="<?php echo esc_url($compact_option['logo']['url']); ?>" alt="" class="logo">
                    </a>
                </div>
            <?php } ?>
            <!-- logo close -->

            <!-- Header Group Button Right begin -->
            <div class="header-buttons pull-right hidden-xs hidden-sm">  
                <?php if($compact_option['menu_right'] == true){ ?>
                    <div class="navright-button">
                        <a href="" id="btn-offcanvas-menu"><i class="fa fa-bars"></i></a>
                    </div>
                <?php } ?> 

                <?php if (class_exists('Woocommerce')) { ?>
                    <div class="cart-button">
                        <a href="<?php echo WC()->cart->get_cart_url(); ?>" class="cart-contents"><i class="fa fa-shopping-bag"></i> <span class="mini-cart-counter">0</span></a>
                    </div>
                <?php } ?>               
                
                <?php if($compact_option['search_head'] == true){ ?>
                    <!-- Button Modal popup searchbox -->
                    <div class="search-button">
                        <!-- Trigger the modal with a button -->
                        <a href="" data-toggle="modal" data-target="#myModal"><i class="fa fa-search"></i></a>                                                                        
                    </div>
                <?php } ?>

                <?php if($compact_option['header_infos'] != ''){ ?>
                    <div class="header-contact">
                        <?php echo wp_kses( $compact_option['header_infos'], wp_kses_allowed_html('post') ); ?>
                    </div>
                <?php } ?>                            
            </div>
            <!-- Header Group Button Right close -->

            <!-- desktop menu begin -->
            <nav id="desktop-menu" class="site-desktop-menu site-desktop-menu-3 hidden-xs hidden-sm">
                <?php
                    $topmenu = array(
                        'theme_location'  => 'primary',
                        'menu'            => '',
                        'container'       => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'menu_class'      => 'clearfix',
                        'menu_id'         => '',
                        'echo'            => true,
                        'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                        'walker'          => new wp_bootstrap_navwalker(),
                        'before'          => '',
                        'after'           => '',
                        'link_before'     => '',
                        'link_after'      => '',
                        'items_wrap'      => '<ul data-breakpoint="800" id="%1$s" class="%2$s">%3$s</ul>',
                        'depth'           => 0,
                    );
                    if ( has_nav_menu( 'primary' ) ) {
                        wp_nav_menu( $topmenu );
                    }
                ?>
            </nav>
            <!-- desktop menu close -->

            <!-- btn-mobile menu begin -->
            <a id="show-mobile-menu" class="btn-mobile-menu hidden-lg hidden-md"><i class="fa fa-bars"></i></a>
            <!-- btn-mobile menu close --> 

            <!-- mobile menu begin -->
            <nav id="mobile-menu" class="site-mobile-menu hidden-lg hidden-md">
                <ul></ul>
            </nav>  
            <!-- mobile menu close -->  

        </div>
      </div>
    </div>
  </div>
</header>
<!-- header close -->
<div class="gray-line3"></div>

<?php if($compact_option['search_head'] == true){ ?>
    <!-- Modal Search begin -->
    <div id="myModal" class="modal fade" role="dialog">
      <button type="button" class="close" data-dismiss="modal">&times;</button>
      <div class="modal-dialog myModal-search">
        <!-- Modal content-->
        <div class="modal-content">                                        
            <div class="modal-body">
                <?php get_search_form(); ?>
            </div>
        </div>
      </div>
    </div>
    <!-- Modal Search close -->
<?php } ?>

<!-- Menu OffCanvas right begin -->
<?php if($compact_option['menu_right'] == true){ ?>
    <div class="navright-button hidden-sm">
        <div class="compact-menu-canvas" id="offcanvas-menu">
            <?php if($compact_option['title_menu_right'] != ''){ ?><h3><?php echo esc_attr($compact_option['title_menu_right']); ?><?php } ?></h3><a id="btn-close-canvasmenu"><i class="fa fa-close"></i></a>
            <nav>
            <?php
                $topmenu = array(
                    'theme_location'  => 'other',
                    'menu'            => '',
                    'container'       => '',
                    'container_class' => '',
                    'container_id'    => '',
                    'menu_class'      => 'clearfix',
                    'menu_id'         => '',
                    'echo'            => true,
                    'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                    'walker'          => new wp_bootstrap_navwalker(),
                    'before'          => '',
                    'after'           => '',
                    'link_before'     => '',
                    'link_after'      => '',
                    'items_wrap'      => '<ul data-breakpoint="800" id="%1$s" class="%2$s">%3$s</ul>',
                    'depth'           => 0,
                );
                if ( has_nav_menu( 'other' ) ) {
                    wp_nav_menu( $topmenu );
                }
            ?>                   
            </nav>
        </div>
    </div> 
<?php } ?>
<!-- Menu OffCanvas right close -->