<?php
/**
 * Enqueues front-end CSS for color scheme.
 *
 * @since Twenty Fifteen 1.0
 *
 * @see wp_add_inline_style()
 */
function compact_color_scheme_css() {
	global $compact_option; 
	wp_add_inline_style( 'compact-style', compact_get_color_scheme_css() );
}
add_action( 'wp_enqueue_scripts', 'compact_color_scheme_css' );

/**
 * Returns CSS for the color schemes.
 *
 * @since Twenty Fifteen 1.0
 *
 * @param array $colors Color scheme colors.
 * @return string Color scheme CSS.
 */
function compact_get_color_scheme_css() {
	global $compact_option;
	$css = <<<CSS
	/* Color Scheme */	

	a{color: {$compact_option['main-color']};}

	/* default color: #29b6f6*/
	nav.site-desktop-menu ul li ul li a:hover, .feature:hover i,
	.latest-projects .latest-projects-intro, .owl-theme .owl-controls.clickable .owl-buttons div:hover, 
	.sep-background-mask, form .newsletter input[type="submit"], .pro-bar, .btn-primary, .owl-theme .owl-controls .owl-buttons div:hover,
	 #to-the-top:hover, .box-intro-video .btn-intro-video, .tagcloud a:hover, #myModal .close,
	.pagination li span.current, .pagination li a:hover, .comments-area input[type=submit], 
	#btn-close-canvasmenu, .compact-menu-canvas nav ul li a:hover, .header-buttons .cart-button .mini-cart-counter, 
	.social-share a:hover, .owl-theme .owl-controls .owl-page span, .latest-projects-wrapper .owl-theme .owl-controls .owl-buttons div, .compact-buttons div:hover,
	div.vc_tta-tabs:not([class*=vc_tta-gap]):not(.vc_tta-o-no-fill).vc_tta-tabs-position-top.tab4 .vc_tta-tab.vc_active>a::before,
	div.vc_tta-tabs:not([class*=vc_tta-gap]):not(.vc_tta-o-no-fill).vc_tta-tabs-position-top .vc_tta-tab.vc_active>a,
	div.vc_tta-tabs.vc_tta-color-white.vc_tta-style-classic.tab2 .vc_tta-panel.vc_active .vc_tta-panel-title>a:before,
	div.vc_tta-tabs.vc_tta-color-white.vc_tta-style-classic.tab3 .vc_tta-panel.vc_active .vc_tta-panel-title>a,
	div.vc_tta.vc_tta-accordion .vc_tta-controls-icon-position-left.vc_tta-panel-title>a:hover, 
	div.vc_tta-color-white.vc_tta-style-classic.tab1 .vc_tta-panel.vc_active .vc_tta-panel-title>a,
	div.vc_tta-accordion.vc_tta-color-white.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title>a,
	div.vc_tta-tabs:not([class*=vc_tta-gap]):not(.vc_tta-o-no-fill).vc_tta-tabs-position-top.tab2 .vc_tta-tab.vc_active>a::after,
	.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, 
	.woocommerce #respond input#submit.disabled, .woocommerce #respond input#submit:disabled, .woocommerce #respond input#submit[disabled]:disabled, 
	.woocommerce a.button.disabled, .woocommerce a.button:disabled, .woocommerce a.button[disabled]:disabled, .woocommerce button.button.disabled, 
	.woocommerce button.button:disabled, .woocommerce button.button[disabled]:disabled, 
	.woocommerce input.button.disabled, .woocommerce input.button:disabled, .woocommerce input.button[disabled]:disabled,
	.woocommerce .woocommerce-pagination ul.page-numbers li span.current, .woocommerce .woocommerce-pagination ul.page-numbers li a:hover,
	.woocommerce .button.add_to_cart_button, .woocommerce .added_to_cart.wc-forward
	{
		background-color:{$compact_option['main-color']};
	}
	.team-box:hover .team-inner .mask, .box-intro-video .btn-intro-video:hover{
		background-color: {$compact_option['main-color']};
		opacity: 0.8;
	}
	.header-buttons a i.fa:hover, .feature i, .project-details .folio-buttons i, .testi-boxes blockquote:before,
	.latest-blog-post-img .latest-blog-post-date, .latest-blog-post-details p.title a:hover,
	.latest-blog-post-details .latest-blog-post-data span.tags i, .latest-blog-post-details .latest-blog-post-data span.tags a:hover,
	.latest-blog-post-details .latest-blog-post-data span.btn-read a i,
	.latest-blog-post-details .latest-blog-post-data span.btn-read a:hover, footer .main-footer .widget-inner ul li a:hover,
	.site-header-2 .search-bar .search-submit:hover, .project-details p.folio-cate i, #filter li .current, #filter li a:hover,
	.widget_search .search-submit:hover, .team-box .team-inner ul li a:hover, .pricing-table-2 .plan-price,
	ul.countdown li span, .post-metadata i, .main-sidebar .widget ul li a:hover, .post-content .post-title a:hover, .post-metadata a:hover,
	nav.site-desktop-menu > ul > li > a:hover, .single-tags .fa, a.btn.btn-border-grey:hover,.single-tags a:hover,
	.nav-links a:hover .post-title,.comment-reply-link:hover, .widget .search-form .search-submit:hover, .project-details p a:hover,
	.post-date .date-day
	{
		color: {$compact_option['main-color']};
	}
	body, .pricing-item, header.site-header {
		border-top-color: {$compact_option['main-color']};
	}
	.feature i, .project-details .folio-buttons i, nav.site-desktop-menu > ul > li > ul, .social-share a:hover,
	.tagcloud a:hover, .compact-buttons div:hover, .testimonials-slider-wrapper .owl-theme .owl-controls .owl-buttons div:hover,
	.latest-blog-posts .owl-theme .owl-controls .owl-buttons div:hover,
	div.vc_tta-accordion.vc_tta-color-white.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title>a,
	a.btn.btn-border-grey:hover
	{
		border-color: {$compact_option['main-color']};
	}
	blockquote {
		border-left-color: {$compact_option['main-color']};
	}
	.site-header-1 .stuck,div.vc_tta-color-white.vc_tta-style-classic.tab4 .vc_tta-panel.vc_active .vc_tta-panel-title>a  {
		border-top-color: {$compact_option['main-color']};
	}
	.tab3.vc_tta.vc_tta-spacing-1 .vc_tta-tabs-list {
		border-bottom-color: {$compact_option['main-color']};
	}
	::-moz-selection { 
	    color: #fff;
	    background: {$compact_option['main-color']};
	}
	::selection {
	    color: #fff;
	    background: {$compact_option['main-color']};
	}

CSS;
	return $css;
}