<?php
/**
 * Template Name: Blog Grid
 */
get_header();

?>

<section id="subheader" data-speed="8" data-type="background" class="subheader padding-top-bottom" 
    <?php if( function_exists( 'rwmb_meta' ) ) { ?>       
    <?php $images = rwmb_meta( '_cmb_bg_header', "type=image" ); ?>
        <?php if($images){ foreach ( $images as $image ) { ?>
        <?php $img =  $image['full_url']; ?>
          style="background-image: url('<?php echo esc_url($img); ?>');"
        <?php } } ?>
    <?php } ?>
>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1><?php echo esc_html_e('Blog List', 'compact') ?></h1>
                <?php if($compact_option['breadcrumbs'] == true){ ?>
                    <?php compact_breadcrumbs(); ?>
                <?php } ?>    
            </div>
        </div>
    </div>
</section>
<!--  END OF HEADER -->

<div id="content">
    <div class="container">
        <div class="row"> 
                <div id="blog-grid" class="blog-grid">
                    <?php 
                    $args = array(    
                      'paged' => $paged,
                      'post_type' => 'post',
                    );
                    $wp_query = new WP_Query($args);
                   while (have_posts()) : the_post();
                   ?>
                   <?php $format = get_post_format(); ?>
                   <article class="item col-md-4 col-sm-6">
                    <div class="post-media">
                    <?php if($format=='image'){ ?>
                        <?php
					      if ( function_exists('rwmb_meta') ) { 
					      ?>
					      <?php $images = rwmb_meta( '_cmb_image', "type=image" ); ?>

					      <?php if($images){ ?>
					      <?php foreach ( $images as $image ) { ?>
					      <?php $img = $image['full_url']; ?>
					      <img src="<?php echo esc_url($img); ?>" alt="" class="img-responsive" />
					     <?php } } } ?>
					<?php } elseif ($format=='video'){ ?>
						<?php if( function_exists( 'rwmb_meta' ) ) { ?>
			            <?php $link_video = get_post_meta(get_the_ID(),'_cmb_link_video', true); ?>
			            <?php if($link_video){ ?>  
			              
			            <div class="embed-responsive embed-responsive-16by9">
						  <iframe width="100%" height="280" src="<?php echo esc_url( $link_video ); ?>"></iframe>
						  <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());; ?>" alt="image">
						</div>                
			            <?php } ?>
			            <?php } ?> 
			        <?php } elseif ($format=='audio'){ ?>
				        <?php if( function_exists( 'rwmb_meta' ) ) { ?>
			            <?php $link_audio = get_post_meta(get_the_ID(),'_cmb_link_audio', true); ?>
			            <?php if($link_audio){ ?>  
			                <div class="embed-responsive embed-responsive-16by9">
								<iframe width="100%" src="<?php echo esc_url( $link_audio ); ?>"></iframe>
							</div>
			            <?php } ?>
			            <?php } ?>
			        <?php } elseif ($format=='gallery'){ ?>
			        <?php
			        if ( function_exists('rwmb_meta') ) { 
			        ?>
			        <?php $images = rwmb_meta( '_cmb_images', "type=image" ); ?>

			        <?php if($images){ ?>
			        <div class="project-slider">
			          <?php foreach ( $images as $image ) { ?>
			          <?php $img = $image['full_url']; ?>
			            <div class="item"><img src="<?php echo esc_url($img); ?>" alt=""></div>
			          <?php } ?>
			        </div>
			        <?php } } ?>
			        <?php } else{ ?>
					      <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());; ?>" alt="" class="img-responsive" />
					<?php } ?>
                        <div class="post-date">
                            <?php compact_entry_custom_date(); ?>
                        </div>
                    </div>
                    <div class="post-content">
                        <div class="post-title">
                            <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                        </div>
                        <div class="post-metadata">
                            <span class="byline">
                                <i class="fa fa-user"></i>
                                <?php the_author_posts_link(); ?>
                            </span>
                            <span class="cat-links">                                            
                                <i class="fa fa-folder-open"></i>
                                <?php the_category('',', ') ?>
                            </span>                               
                        </div>
                        <div class="post-entry">
                            <p><?php echo compact_excerpt(); ?></p>                            
                        </div>
                    </div>
                </article>
                <?php endwhile; ?> 
                </div>

                <div class="pagination-ourter text-center">
                    <ul class="pagination">
                        <?php echo compact_pagination(); ?>
                    </ul>
                </div>
        </div>
    </div>   
</div>
<!-- content close -->
<?php get_footer(); ?>