<?php
/*
 * Template Name: Coming Soon Page
 * Description: A Page Template.
 */
?>
<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8 no-js lt-ie9" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8) ]><!-->
<html <?php language_attributes(); ?>>
<?php global $compact_option; ?>
<!--<![endif]-->
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="SKYPE_TOOLBAR" content="SKYPE_TOOLBAR_PARSER_COMPATIBLE" />

    <!-- Page Title 
    ================================================== -->
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

    <?php compact_custom_favicon(); ?>

<?php wp_head(); ?>
</head>

<body class="no-boder">
  <?php if($compact_option['preload-switch'] == true){ ?>
        <!-- Preload images start //-->
        <div class="images-preloader" id="images-preloader">
          <div class="spinner">
              <div class="bounce1"></div>
              <div class="bounce2"></div>
              <div class="bounce3"></div>
          </div>
        </div>
        <!-- Preload images end //-->
    <?php } ?>
    
<section id="section-coming-soon" class="coming-soon no-padding" style="background-image:url(<?php echo esc_url($compact_option['bg_cs']['url']); ?>)">
    <div class="container">
        <div class="coming-soon-content text-center">            
            <div class="intro-text">
                <h2><?php echo esc_attr($compact_option['title_cs']); ?></h2>
                <p><?php echo htmlspecialchars_decode($compact_option['stitle_cs']); ?></p>
            </div>
            <?php 
              // Check if bbPress plugin is loaded
              if ( class_exists( 'Newsletter' ) ) {
            ?>
            
              <div class="newsletter-comingsoon">
                <script type="text/javascript">
                    if (typeof newsletter_check !== "function") {
                      window.newsletter_check = function (f) {
                          var re = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-]{1,})+\.)+([a-zA-Z0-9]{2,})+$/;
                          if (!re.test(f.elements["ne"].value)) {
                              alert("The email is not correct");
                              return false;
                          }
                          for (var i=1; i<20; i++) {
                          if (f.elements["np" + i] && f.elements["np" + i].required && f.elements["np" + i].value == "") {
                              alert("");
                              return false;
                          }
                          }
                          if (f.elements["ny"] && !f.elements["ny"].checked) {
                              alert("You must accept the privacy statement");
                              return false;
                          }
                          return true;
                      }
                    }
                </script>
                <form method="post" action="<?php echo esc_url( home_url( '/' ) ); ?>?na=s" onsubmit="return newsletter_check(this)">
                    <input class="newsletter-email input-text" type="email" name="ne" size="30" placeholder="<?php echo esc_html_e('Your Email Address','compact'); ?>" required>                
                    <button class="newsletter-submit btn" type="submit" ><i class="fa fa-paper-plane"></i> <?php echo esc_html_e('Subcribe','compact'); ?></button>                  
                </form>
              </div>
            
            <?php } ?>

            <div class="spacer-single"></div>
            <div class="divider-single"></div>
            <div class="col-md-8 col-md-offset-2">                    
                <ul class="countdown">
                  <li> 
                    <span class="days">00</span>
                    <p class="days_ref"><?php echo esc_html_e('days','compact'); ?></p>
                  </li>
                  <li class="seperator"></li>
                  <li>
                    <span class="hours">00</span>
                    <p class="hours_ref"><?php echo esc_html_e('hours','compact'); ?></p>
                  </li>
                  <li class="seperator"></li>
                  <li> 
                    <span class="minutes">00</span>
                    <p class="minutes_ref"><?php echo esc_html_e('minutes','compact'); ?></p>
                  </li>
                  <li class="seperator"></li>
                  <li>
                    <span class="seconds">00</span>
                    <p class="seconds_ref"><?php echo esc_html_e('seconds','compact'); ?></p>
                  </li>
                </ul>
            </div>
            <div class="spacer-single"></div>
            <div class="social-icons">
              <?php 
                if (isset($compact_option['social-list']) && !empty($compact_option['social-list'])) {
                    foreach ($compact_option['social-list'] as $idx => $arr) {                                
                        echo '<a href="' . $arr['url'] . '" class="tipped" data-title="' . $arr['title'] . '" data-tipper-options="{"direction":"top","follow":"true"}" ><i class="fa-lg fa fa-' . $arr['description'] . '"></i></a>';
                    }
                }
              ?>
            </div>
        </div>            
    </div>
</section>

<script type="text/javascript">
  /**
   * downCount: Simple Countdown clock with offset
   * Author: Sonny T. <hi@sonnyt.com>, sonnyt.com
   */

  (function ($) {
    $.fn.downCount = function (options, callback) {
      var settings = $.extend({
          date: null,
          offset: null
        }, options);

      // Throw error if date is not set
      if (!settings.date) {
        $.error('Date is not defined.');
      }

      // Throw error if date is set incorectly
      if (!Date.parse(settings.date)) {
        $.error('Incorrect date format, it should look like this, 12/24/2012 12:00:00.');
      }

      // Save container
      var container = this;

      /**
       * Change client's local date to match offset timezone
       * @return {Object} Fixed Date object.
       */
      var currentDate = function () {
        // get client's current date
        var date = new Date();

        // turn date to utc
        var utc = date.getTime() + (date.getTimezoneOffset() * 60000);

        // set new Date object
        var new_date = new Date(utc + (3600000*settings.offset))

        return new_date;
      };

      /**
       * Main downCount function that calculates everything
       */
      function countdown () {
        var target_date = new Date(settings.date), // set target date
          current_date = currentDate(); // get fixed current date

        // difference of dates
        var difference = target_date - current_date;

        // if difference is negative than it's pass the target date
        if (difference < 0) {
          // stop timer
          clearInterval(interval);

          if (callback && typeof callback === 'function') callback();

          return;
        }

        // basic math variables
        var _second = 1000,
          _minute = _second * 60,
          _hour = _minute * 60,
          _day = _hour * 24;

        // calculate dates
        var days = Math.floor(difference / _day),
          hours = Math.floor((difference % _day) / _hour),
          minutes = Math.floor((difference % _hour) / _minute),
          seconds = Math.floor((difference % _minute) / _second);

          // fix dates so that it will show two digets
          days = (String(days).length >= 2) ? days : '0' + days;
          hours = (String(hours).length >= 2) ? hours : '0' + hours;
          minutes = (String(minutes).length >= 2) ? minutes : '0' + minutes;
          seconds = (String(seconds).length >= 2) ? seconds : '0' + seconds;

        // based on the date change the refrence wording
        var ref_days = (days === 1) ? 'day' : '<?php esc_html_e('days', 'compact');  ?>',
          ref_hours = (hours === 1) ? 'hour' : '<?php esc_html_e('hours', 'compact');  ?>',
          ref_minutes = (minutes === 1) ? 'minute' : '<?php esc_html_e('minutes', 'compact');  ?>',
          ref_seconds = (seconds === 1) ? 'second' : '<?php esc_html_e('seconds', 'compact');  ?>';
          

        // set to DOM
        container.find('.days').text(days);
        container.find('.hours').text(hours);
        container.find('.minutes').text(minutes);
        container.find('.seconds').text(seconds);

        container.find('.days_ref').text(ref_days);
        container.find('.hours_ref').text(ref_hours);
        container.find('.minutes_ref').text(ref_minutes);
        container.find('.seconds_ref').text(ref_seconds);
      };
      
      // start
      var interval = setInterval(countdown, 1000);
    };

  })(jQuery); 
  
  (function($) { "use strict";      
    //Timer
    $('.countdown').downCount({
      date: '<?php echo htmlspecialchars_decode($compact_option['cmsoon_date']); ?> 12:00:00',
      offset: +10
    }, function () {
      alert('WOOT WOOT, done!');
    });

    //Home Sections fit screen        
    $(function(){"use strict";
      $('#section-coming-soon').css({'height':($(window).height())+'px'});
      $(window).resize(function(){
        $('#section-coming-soon').css({'height':($(window).height())+'px'});
      });

      var height = ($(window).height() - $(".coming-soon-content").outerHeight())/2;
        $(".coming-soon-content").css("padding-top",height+"px");   
    }); 
  })(jQuery);
</script>
  
<?php wp_footer(); ?>
</body>
</html>