<?php

get_header();

global $compact_option;
?>

<section id="subheader" data-speed="8" data-type="background" class="padding-top-bottom" <?php if($compact_option['bg_blog'] != ''){ ?> style="background-image:url(<?php echo esc_url($compact_option['bg_blog']['url']); ?>)"<?php } ?>>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1><?php esc_html_e('Blog List', 'compact') ?></h1>
                <?php if($compact_option['breadcrumbs'] == true){ ?>
                <ul class="breadcrumbs">
                    <?php compact_breadcrumbs(); ?>
                </ul>        
                <?php } ?>    
            </div>
        </div>
    </div>
</section>

 <!-- content begin -->
<div id="content">
    <div class="container">
        <div class="row"> 
            <div class="col-md-9">
                <div class="blog-list">
                    <!-- post begin -->

                    <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>                        

                    <?php get_template_part( 'content', get_post_format() ) ; ?>

                    <?php endwhile; else: ?>

                        <h1><?php esc_html_e('Nothing Found Here!', 'compact'); ?></h1>

                    <?php endif ?>
                    <!-- post close -->
                </div>

                <!-- pagination begin -->
                <div class="pagination-ourter text-center">
                    <ul class="pagination">
                        <?php echo compact_pagination(); ?>
                    </ul>
                </div>
                 <!-- pagination close -->

            </div>

            <div class="col-md-3">
                <div class="main-sidebar">
                    <?php get_sidebar();?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- content close -->
<?php get_footer(); ?>