<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Compact
 */

if ( ! function_exists( 'compact_entry_meta' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function compact_entry_meta() {
    if (is_single()) {
        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
        if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
            $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';
        }

        $time_string = sprintf( $time_string,
            esc_attr( get_the_date( 'c' ) ),
            esc_html( get_the_date() ),
            esc_attr( get_the_modified_date( 'c' ) ),
            esc_html( get_the_modified_date() )
        );

        $posted_on = sprintf(
            esc_html_x( '%s', 'post date', 'compact' ), $time_string );
        echo '<span class="posted-on"><i class="fa fa-clock-o"></i> ' . $posted_on . '</span>';
        //the_time( get_option( 'date_format' ) );
    }
    $byline = sprintf(
        esc_html_x( '%s', 'post author', 'compact' ),
        '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
    );

    echo '<span class="byline"><i class="fa fa-user"></i> ' . $byline . '</span>'; // WPCS: XSS OK.

    // Hide category and tag text for pages.
    if ( 'post' === get_post_type() ) {
        /* translators: used between list items, there is a space after the comma */
        $categories_list = get_the_category_list( esc_html__( ', ', 'compact' ) );
        if ( $categories_list && compact_theme_categorized_blog() ) {
            printf( '<span class="cat-links"><i class="fa fa-folder-open"></i>' . esc_html__( ' %1$s', 'compact' ) . '</span>', $categories_list ); // WPCS: XSS OK.
        }
    }

    if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
        echo '<span class="comments-link"><i class="fa fa-comments-o"></i> ';
        comments_popup_link( esc_html__( '0 comment', 'compact' ), esc_html__( '1 Comment', 'compact' ), esc_html__( '% Comments', 'compact' ) );
        echo '</span>';
    }
}
endif;

// Customize blog date 
if ( ! function_exists( 'compact_entry_custom_date' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time.
 */
function compact_entry_custom_date() {
    echo '<span class="date-day">' . get_the_time('d') . '</span>
        <span class="date-month">' . get_the_time('M') . '</span>';   
}
endif;

                      

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function compact_theme_categorized_blog() {
    if ( false === ( $all_the_cool_cats = get_transient( 'compact_theme_categories' ) ) ) {
        // Create an array of all the categories that are attached to posts.
        $all_the_cool_cats = get_categories( array(
            'fields'     => 'ids',
            'hide_empty' => 1,

            // We only need to know if there is more than one category.
            'number'     => 2,
        ) );

        // Count the number of categories that are attached to the posts.
        $all_the_cool_cats = count( $all_the_cool_cats );

        set_transient( 'compact_theme_categories', $all_the_cool_cats );
    }

    if ( $all_the_cool_cats > 1 ) {
        // This blog has more than 1 category so compact_theme_categorized_blog should return true.
        return true;
    } else {
        // This blog has only 1 category so compact_theme_categorized_blog should return false.
        return false;
    }
}

/**
 * Flush out the transients used in compact_theme_categorized_blog.
 */
function compact_theme_category_transient_flusher() {
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }
    // Like, beat it. Dig?
    delete_transient( 'compact_theme_categories' );
}
add_action( 'edit_category', 'compact_theme_category_transient_flusher' );
add_action( 'save_post',     'compact_theme_category_transient_flusher' );


if ( ! function_exists( 'compact_excerpt' ) ) :
/**** Change length of the excerpt ****/
function compact_excerpt() {
      global $compact_option;
      if(isset($compact_option['excerpt_length'])){
        $limit = $compact_option['excerpt_length'];
      }else{
        $limit = 15;
      }  
      $excerpt = explode(' ', get_the_excerpt(), $limit);

      if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'...';
      } else {
        $excerpt = implode(" ",$excerpt);
      } 
      $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
      return $excerpt;
}
endif;

if ( ! function_exists( 'compact_blog_excerpt' ) ) :
/** Excerpt Section Blog Post **/
function compact_blog_excerpt($limit) {
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}
endif;

if ( ! function_exists( 'image_size_theme_setup' ) ) :
add_action( 'after_setup_theme', 'image_size_theme_setup' );
function image_size_theme_setup() {
    add_image_size( 'category-thumb', 300 ); // 300 pixels wide (and unlimited height)
    add_image_size( 'portfolio_thumbnail', 750, 561, array( 'left', 'top' ) ); // (cropped)
}
endif;

if ( ! function_exists( 'compact_breadcrumbs' ) ) :
function compact_breadcrumbs() {
    $text['home']     = esc_html__('Home', 'compact'); // text for the 'Home' link
    $text['category'] = '%s'; // text for a category page
    $text['tax']      = '%s'; // text for a taxonomy page
    $text['search']   = '%s'; // text for a search results page
    $text['tag']      = '%s'; // text for a tag page
    $text['author']   = '%s'; // text for an author page
    $text['404']      = '404'; // text for the 404 page
    $showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
    $showOnHome  = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
    $delimiter   = ''; // delimiter between crumbs
    $before      = '<li class="active">'; // tag before the current crumb
    $after       = '</li>'; // tag after the current crumb
    
    global $post;
    $homeLink = esc_url(home_url('/')) . '';
    $linkBefore = '<li>';
    $linkAfter = '</li>';
    $linkAttr = ' rel="v:url" property="v:title"';
    $link = $linkBefore . '<a' . $linkAttr . ' href="%1$s">%2$s</a>' . $linkAfter;
 
    if (is_home() || is_front_page()) {
 
        if ($showOnHome == 1) echo '<div class="breadcrumbs"><a href="' . $homeLink . '">' . $text['home'] . '</a></div>';
 
    } else {
 
        echo '<ul class="breadcrumbs">' . sprintf($link, $homeLink, $text['home']) . $delimiter;
 
        
        if ( is_category() ) {
            $thisCat = get_category(get_query_var('cat'), false);
            if ($thisCat->parent != 0) {
                $cats = get_category_parents($thisCat->parent, TRUE, $delimiter);
                $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
                $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
                echo htmlspecialchars_decode( $cats );
            }
            echo htmlspecialchars_decode( $before ) . sprintf($text['category'], single_cat_title('', false)) . htmlspecialchars_decode( $after );
 
        } elseif( is_tax() ){
            $thisCat = get_category(get_query_var('cat'), false);
            if ($thisCat->parent != 0) {
                $cats = get_category_parents($thisCat->parent, TRUE, $delimiter);
                $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
                $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
                echo htmlspecialchars_decode( $cats );
            }
            echo htmlspecialchars_decode( $before ) . sprintf($text['tax'], single_cat_title('', false)) . htmlspecialchars_decode( $after );
        
        }elseif ( is_search() ) {
            echo htmlspecialchars_decode( $before ) . sprintf($text['search'], get_search_query()) . htmlspecialchars_decode( $after );
 
        } elseif ( is_day() ) {
            echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
            echo sprintf($link, get_month_link(get_the_time('Y'),get_the_time('m')), get_the_time('F')) . $delimiter;
            echo htmlspecialchars_decode( $before ) . get_the_time('d') . htmlspecialchars_decode( $after );
 
        } elseif ( is_month() ) {
            echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
            echo htmlspecialchars_decode( $before ) . get_the_time('F') . htmlspecialchars_decode( $after );
 
        } elseif ( is_year() ) {
            echo htmlspecialchars_decode( $before ) . get_the_time('Y') . htmlspecialchars_decode( $after );
 
        } elseif ( is_single() && !is_attachment() ) {
            if ( get_post_type() != 'post' ) {
                $post_type = get_post_type_object(get_post_type());
                $slug = $post_type->rewrite;                
                if ( get_post_type() == 'portfolio' ) {
                    printf($link, $homeLink . '' . $slug['slug'] . '/', 'Portfolio'); //Translate breadcrumb.
                }else{
                    printf($link, $homeLink . '/' . $slug['slug'] . '/', $post_type->labels->singular_name);
                }
                if ($showCurrent == 1) echo htmlspecialchars_decode( $delimiter ) . $before . get_the_title() . $after;
            } else {
                $cat = get_the_category(); $cat = $cat[0];
                $cats = get_category_parents($cat, TRUE, $delimiter);
                if ($showCurrent == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
                $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
                $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
                echo htmlspecialchars_decode( $cats );
                if ($showCurrent == 1) echo htmlspecialchars_decode( $before ) . get_the_title() . $after;
            }
 
        } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
            $post_type = get_post_type_object(get_post_type());
            echo htmlspecialchars_decode( $before ) . $post_type->labels->singular_name . htmlspecialchars_decode( $after );
 
        } elseif ( is_attachment() ) {
            $parent = get_post($post->post_parent);
            $cat = get_the_category($parent->ID); $cat = $cat[0];
            $cats = get_category_parents($cat, TRUE, $delimiter);
            $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
            $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
            echo htmlspecialchars_decode( $cats );
            printf($link, get_permalink($parent), $parent->post_title);
            if ($showCurrent == 1) echo htmlspecialchars_decode( $delimiter ) . $before . get_the_title() . $after;
 
        } elseif ( is_page() && !$post->post_parent ) {
            if ($showCurrent == 1) echo htmlspecialchars_decode( $before ) . get_the_title() . $after;
 
        } elseif ( is_page() && $post->post_parent ) {
            $parent_id  = $post->post_parent;
            $breadcrumbs = array();
            while ($parent_id) {
                $page = get_page($parent_id);
                $breadcrumbs[] = sprintf($link, get_permalink($page->ID), get_the_title($page->ID));
                $parent_id  = $page->post_parent;
            }
            $breadcrumbs = array_reverse($breadcrumbs);
            for ($i = 0; $i < count($breadcrumbs); $i++) {
                echo htmlspecialchars_decode( $breadcrumbs[$i] );
                if ($i != count($breadcrumbs)-1) echo htmlspecialchars_decode( $delimiter );
            }
            if ($showCurrent == 1) echo htmlspecialchars_decode( $delimiter ) . $before . get_the_title() . $after;
 
        } elseif ( is_tag() ) {
            echo htmlspecialchars_decode( $before ) . sprintf($text['tag'], single_tag_title('', false)) . $after;
 
        } elseif ( is_author() ) {
             global $author;
            $userdata = get_userdata($author);
            echo htmlspecialchars_decode( $before ) . sprintf($text['author'], $userdata->display_name) . $after;
 
        } elseif ( is_404() ) {
            echo htmlspecialchars_decode( $before ) . $text['404'] . $after;
        }
 
        if ( get_query_var('paged') ) {
            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() );
            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
        }
 
        echo '</ul>';
 
    }
}
endif;

if ( ! function_exists( 'compact_pagination' ) ) :
//pagination
function compact_pagination($prev = '<i class="fa fa-angle-double-left"></i>', $next = '<i class="fa fa-angle-double-right"></i>', $pages='') {
    global $wp_query, $wp_rewrite;
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
    if($pages==''){
        global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
    }
    $pagination = array(
        'base'          => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
        'format'        => '',
        'current'       => max( 1, get_query_var('paged') ),
        'total'         => $pages,      
    'type'          => 'list',
    'prev_text'     => $prev,
    'next_text'     => $next,
        'end_size'      => 3,
        'mid_size'      => 3
    );
    $return =  paginate_links( $pagination );
    echo str_replace( "<ul class='page-numbers'>", '', $return );
}
endif;

if ( ! function_exists( 'compact_custom_wp_admin_style' ) ) :
function compact_custom_wp_admin_style() {

        wp_register_style( 'compact_custom_wp_admin_css', get_template_directory_uri() . '/framework/admin/admin-style.css', false, '1.0.0' );
        wp_enqueue_style( 'compact_custom_wp_admin_css' );

        wp_enqueue_script( 'compact-backend-js', get_template_directory_uri()."/framework/admin/admin-script.js", array( 'jquery' ), '1.0.0', true );
        wp_enqueue_script( 'compact-backend-js' );
}
add_action( 'admin_enqueue_scripts', 'compact_custom_wp_admin_style' );
endif;

if ( ! function_exists( 'compact_search_form' ) ) :
/* Custom form search */
function compact_search_form( $form ) {
    $form = '<form role="search" method="get" class="search-form" action="' . home_url( '/' ) . '" > 
        <span class="search-box"> 
            <input class="search-field" type="search" value="' . get_search_query() . '" name="s" id="s" placeholder="'.esc_html__('Search', 'compact').'" />
            <button class="search-submit" type="submit"><i class="fa fa-search"></i></button>
        </span>
    </form>';
    return $form;
}
add_filter( 'get_search_form', 'compact_search_form' );
endif;

/* Custom comment List: */
function compact_theme_comment($comment, $args, $depth) {    
   $GLOBALS['comment'] = $comment; ?>

    <li class="comment even thread-even depth-1">
        <article class="comment-body" id="comment-<?php comment_ID(); ?>">
          <footer class="comment-meta">
            <div class="comment-author vcard">
                <?php echo get_avatar($comment,$size='80',$default='http://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80' ); ?>
                <b class="fn"><?php printf(esc_html__('%s','compact'), get_comment_author()) ?></b>
                <span class="says"><?php echo esc_html__('says:','compact') ?></span> 
            </div>
            <div class="comment-metadata">
              <time>
                <?php the_time('m/d/Y'); ?><?php echo esc_html__(' at ','compact') ?><?php the_time('H:i a'); ?>
              </time>
            </div>
            <div class="comment-content">
                <?php if ($comment->comment_approved == '0'){ ?>
                     <p><em><?php esc_html_e('Your comment is awaiting moderation.','compact') ?></em></p>
                <?php }else{ ?>
                    <?php comment_text() ?>
                <?php } ?>
                <div class="reply">
                   <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                </div>
            </div>
          </footer>
        </article>
    </li>

<?php
}

// Add specific CSS class by filter
add_filter( 'body_class', 'compact_body_class_names' );
function compact_body_class_names( $classes ) {
    global $compact_option;

    // add 'class-name' to the $classes array
    if(isset($compact_option['theme_layout']) and $compact_option['theme_layout'] == "boxes" ){
        $classes[] = 'compact-boxed-bg '; 
    }

    // return the $classes array
    return $classes;
}

if ( ! function_exists( 'compact_custom_favicon' ) ) :
/**
 * Prints HTML with Custom Favicon.
 */
function compact_custom_favicon() {
    global $compact_option;
    
    if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {        
        if($compact_option['favicon']['url'] !=''){ 
            echo '<link rel="shortcut icon" href="'.($compact_option['favicon']['url']).'">';    
        }
    } 
}
endif;