<?php

    /**
     * For full documentation, please visit: http://docs.reduxframework.com/
     * For a more extensive sample-config file, you may look at:
     * https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "compact_option";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        'opt_name' => 'compact_option',
        'use_cdn' => TRUE,
        'display_name'     => $theme->get('Name'),
        'display_version'  => $theme->get('Version'),
        'page_title' => 'Compact Options',
        'update_notice' => FALSE,
        'admin_bar' => TRUE,
        'menu_type' => 'menu',
        'menu_title' => 'Compact Options',
        'allow_sub_menu' => TRUE,
        'page_parent_post_type' => 'your_post_type',
        'customizer' => FALSE,
        'dev_mode'   => false,
        'default_mark' => '*',
        'hints' => array(
            'icon_position' => 'right',
            'icon_color' => 'lightgray',
            'icon_size' => 'normal',
            'tip_style' => array(
                'color' => 'light',
            ),
            'tip_position' => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect' => array(
                'show' => array(
                    'duration' => '500',
                    'event' => 'mouseover',
                ),
                'hide' => array(
                    'duration' => '500',
                    'event' => 'mouseleave unfocus',
                ),
            ),
        ),
        'output' => TRUE,
        'output_tag' => TRUE,
        'settings_api' => TRUE,
        'cdn_check_time' => '1440',
        'compiler' => TRUE,
        'page_permissions' => 'manage_options',
        'save_defaults' => TRUE,
        'show_import_export' => TRUE,
        'database' => 'options',
        'transient_time' => '3600',
        'network_sites' => TRUE,
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'compact' ),
            'content' => esc_html__( 'This is the tab content, HTML is allowed.', 'compact' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'compact' ),
            'content' => esc_html__( 'This is the tab content, HTML is allowed.', 'compact' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( 'This is the sidebar content, HTML is allowed.', 'compact' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    // ACTUAL DECLARATION OF SECTIONS
    Redux::setSection( $opt_name, array(
        'icon' => ' el-icon-stackoverflow',
        'title' => esc_html__('Miscellaneous Settings', 'compact'),
        'fields' => array(
            array(
                'id'       => 'preload-switch',
                'type'     => 'switch', 
                'title'    => esc_html__('Preload Off?', 'compact'),
                'subtitle' => esc_html__('Look, it\'s on!', 'compact'),
                'default'  => true,
            ),  
            array(
                'id'       => 'animate-switch',
                'type'     => 'switch', 
                'title'    => esc_html__('Animation Off?', 'compact'),
                'subtitle' => esc_html__('Look, it\'s on!', 'compact'),
                'default'  => true,
            ), 
            array(
                'id' => 'breadcrumbs',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumbs', 'compact'),
                'desc' => esc_html__( 'Enable breadcrumbs on the header', 'compact' ),
                'default' => true,
            ),  
            array(
                'id' => 'gmap_api',
                'type' => 'text',
                'title' => esc_html__('Google Map API Key', 'compact'),
                'subtitle' => esc_html__('Add your Google map api key', 'compact'),
                'desc' => esc_html__('Create your Gmap API key here: https://developers.google.com/maps/documentation/javascript/', 'compact'),
                'default' => 'AIzaSyDZJDaC3vVJjxIi2QHgdctp3Acq8UR2Fgk'
            ),                                          
        )
    ) );        
    Redux::setSection( $opt_name, array(
        'icon' => ' el-icon-picture',
        'title' => esc_html__('Logo & Favicon Settings', 'compact'),
        'fields' => array(
            array(
                'id' => 'favicon',
                'type' => 'media',
                'title' => esc_html__('Favicon', 'compact'),
                'compiler' => 'true',
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'subtitle' => esc_html__('Favicon', 'compact'),
                'default' => array('url' => get_template_directory_uri().'/images/favicon.png'),                     
            ),
            array(
                'id' => 'logo',
                'type' => 'media',
                'title' => esc_html__('Logo Static', 'compact'),
                'compiler' => 'true',
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'subtitle' => esc_html__('Logo', 'compact'),
                'default' => array('url' => get_template_directory_uri().'/images/logo.png'),                     
            ),                                                    
        )
    ) );     
            
    Redux::setSection( $opt_name, array(
        'icon' => ' el-icon-qrcode',
        'title' => esc_html__('Header Settings', 'compact'),
        'fields' => array( 
            array(
                'id'       => 'header_layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Images Option for Header Layout', 'compact' ),
                'subtitle' => esc_html__( 'Use any header layout for all pages.', 'compact' ),
                'options'  => array(
                    'header1' => array(
                        'alt' => 'Header Layout 1',
                        'img' => get_template_directory_uri().'/images/theme-options/header1.jpg'
                    ),
                    'header2' => array(
                        'alt' => 'Header Layout 2',
                        'img' => get_template_directory_uri().'/images/theme-options/header2.jpg'
                    ),
                    'header3' => array(
                        'alt' => 'Header Layout 3',
                        'img' => get_template_directory_uri().'/images/theme-options/header3.jpg'
                    )
                ),
                'default'  => 'header1'
            ),                           
            array(
                'id' => 'menu_right',
                'type' => 'switch',
                'title' => esc_html__('Right Menu', 'compact'),
                'default' => true,
            ),                             
            array(
                'id' => 'search_head',
                'type' => 'switch',
                'title' => esc_html__('Form Search in header', 'compact'),
                'default' => true,
            ),
            array(
                'id' => 'title_menu_right',
                'type' => 'text',
                'title' => esc_html__('Title Menu Right', 'compact'),
                'desc' => esc_html__('Add text for menu right', 'compact'),
            ),       
            array(
                'id' => 'header_infos',
                'type' => 'editor',
                'title' => esc_html__('Header Infos', 'compact'),
            ),                        
        )
    ) );
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-blogger',
        'title' => esc_html__('Blog Settings', 'compact'),
        'fields' => array(  
            array(
                'id' => 'bg_blog',
                'type' => 'media',
                'title' => esc_html__('Background Image', 'compact'),
                'desc' => esc_html__('Select Background Image For Blog', 'compact'),
                'default' => array('url' => get_template_directory_uri().'/images/bg/bg-1.jpg')
            ),  
            array(
                'id' => 'excerpt_length',
                'type' => 'text',
                'title' => esc_html__('Blog custom excerpt lenght', 'compact'),
                'desc' => esc_html__('Blog custom excerpt lenght', 'compact'),
                'default' => '26'
            ),   
            array(
                'id' => 'social_share',
                'type' => 'switch',
                'title' => esc_html__('Show social', 'compact'),
                'desc' => esc_html__('Enable social on the single', 'compact'),
                'default' => true,
            ),         
         )
    ) );     
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-shopping-cart-sign',
        'title' => esc_html__('Shop Settings', 'compact'),
        'fields' => array(      
            array(
                'id' => 'product_thumbnail',
                'type' => 'media',
                'title' => esc_html__('Background Image', 'compact'),
                'subtitle' => esc_html__('Background Sub Page Image', 'compact'),
                'default' => array('url' => get_template_directory_uri().'/images/bg/bg-1.jpg')
            ),                                   
        )    
    ));
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-briefcase',
        'title' => esc_html__('Portfolio Settings', 'compact'),
        'fields' => array(      
            array(
                'id' => 'bg_portfolio',
                'type' => 'media',
                'title' => esc_html__('Background Image', 'compact'),
                'subtitle' => esc_html__('Background Sub Page Image', 'compact'),
                'default' => array('url' => get_template_directory_uri().'/images/bg/bg-1.jpg')
            ),                                  
        )    
    ));
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-graph',
        'title' => esc_html__('404 Settings', 'compact'),
        'fields' => array(      
            array(
                'id' => '404_bg',
                'type' => 'media',
                'title' => esc_html__('40 Background Image', 'compact'),
                'subtitle' => esc_html__('Upload 404 Background Image', 'compact'),
                'default' => array('url' => get_template_directory_uri().'/images/404.png')
            ),                                  
        )    
    ));
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-group',
        'title' => esc_html__('Social Settings', 'compact'),
        'fields' => array(
            array(
                'id'          => 'social-list',
                'type'        => 'slides',
                'title'       => esc_html__( 'Social Options', 'compact' ),
                'subtitle'    => esc_html__( 'Unlimited social with drag and drop sortings.', 'compact' ),
                'desc'        => esc_html__( 'Find class social icon here : <a href="http://fontawesome.io/icons/#brand" target="_blank">Find more</a>, add class name e.g: <code>facebook</code>', 'compact' ),
                'placeholder' => array(
                    'title'       => esc_html__( 'This is a social name', 'compact' ),
                    'description' => esc_html__( 'Icon class name here', 'compact' ),
                    'url'         => esc_html__( 'Give us a link!', 'compact' ),
                ),
            ),                          
        )
    ) );
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-hourglass',
        'title' => esc_html__('Coming Soon Settings', 'compact'),
        'fields' => array(      
            array(
                'id' => 'bg_cs',
                'type' => 'media',
                'title' => esc_html__('Background Image', 'compact'),
                'subtitle' => esc_html__('Background Image', 'compact'),
                'desc' => esc_html__('Use For Coming Soon Page', 'compact'),
                'default' => array('url' => get_template_directory_uri().'/images/bg/commingsoon.jpg')
            ), 
            array(
                'id' => 'title_cs',
                'type' => 'text',
                'title' => esc_html__('Title Coming Soon', 'compact'),
                'default' => 'COMING SOON',
            ),
            array(
                'id' => 'stitle_cs',
                'type' => 'text',
                'title' => esc_html__('Subtitle Coming Soon', 'compact'),
                'default' => 'Our website is under construction, follow us for update now!',
            ), 
            array(
                'id'       => 'cmsoon_date',
                'type'     => 'date',
                'title'    => esc_html__( 'Coming Soon Date Option', 'compact' ),
                'subtitle' => esc_html__( 'Select time completed your website.', 'compact' ),
                'default' => '12/30/2016',
            ),                                 
        )    
    ));
    Redux::setSection( $opt_name, array(
        'icon' => ' el-icon-credit-card',
        'title' => esc_html__('Footer Settings', 'compact'),
        'fields' => array( 
            array(
                'id'       => 'footer_layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Images Option for Footer Layout', 'compact' ),
                'subtitle' => esc_html__( 'Use any footer layout for all pages.', 'compact' ),
                'options'  => array(
                    'footer_sidebar' => array(
                        'alt' => 'Footer Layout 1',
                        'img' => get_template_directory_uri().'/images/theme-options/footer1.jpg'
                    ),
                    'no_sidebar' => array(
                        'alt' => 'Footer Layout 2',
                        'img' => get_template_directory_uri().'/images/theme-options/footer2.jpg'
                    )
                ),
                'default'  => 'footer_sidebar'
            ),  
            array(
                'id' => 'logo_footer',
                'type' => 'media',
                'title' => esc_html__('Logo Footer', 'compact'),
                'compiler' => 'true',
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'subtitle' => esc_html__('Upload logo (Use in footer layout 2)', 'compact'),
                'default' => array('url' => get_template_directory_uri().'/images/logo-footer2.png'),                     
            ),                          
            array(
                'id' => 'footer_content',
                'type' => 'editor',
                'title' => esc_html__('Footer Content (Use in footer layout 2)', 'compact'),
            ),  
            array(
                'id' => 'footer-contact',
                'type' => 'editor',
                'title' => esc_html__('Footer Contact (Use in footer layout 2)', 'compact'),
            ),                                                           
            array(
                'id' => 'fcopyright',
                'type' => 'editor',
                'title' => esc_html__('Copyright Text', 'compact'),
            ),               
        )
    ) );        
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-website',
        'title' => esc_html__('Styling Options', 'compact'),
        'fields' => array(  
            array(
                'id' => 'theme_layout',
                'type' => 'select',
                'title' => esc_html__('Theme layout', 'compact'),
                'desc' => esc_html__('Theme layout : select boxes or wide.', 'compact'),
                'options'  => array(
                    'wide' => 'Wide layout', 
                    'boxes' => 'Boxes layout',                          
                ),
                'default' => 'wide',
            ),                                 
            array(
                'id' => 'main-color',
                'type' => 'color',
                'title' => esc_html__('Theme Main Color', 'compact'),
                'subtitle' => esc_html__('Pick the main color for the theme (default: #29b6f6).', 'compact'),
                'default' => '#29b6f6',
                'validate' => 'color',
            ),  
            array(
                'id' => 'custom-css',
                'type' => 'ace_editor',
                'title' => esc_html__('CSS Code', 'compact'),
                'subtitle' => esc_html__('Paste your CSS code here.', 'compact'),
                'mode' => 'css',
                'theme' => 'monokai',
                'desc' => 'Possible modes can be found at.',
                'default' => "#header{\nmargin: 0 auto;\n}"
            ),
        )
    ) );
    
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Background layout boxes.', 'compact' ),
        'id'         => 'design-background',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'boxed-background',
                'type'     => 'background',
                'output'   => array( 'body' ),
                'title'    => esc_html__( 'Body Background', 'compact' ),
                'subtitle' => esc_html__( 'Body background with image, color, etc.', 'compact' ),
                //'default'   => '#FFFFFF',
            ),
        ),        
    ) );
    
    /*
     * <--- END SECTIONS
     */
