<?php

/**
 * Register meta boxes
 *
 * @since 1.0
 *
 * @param array $meta_boxes
 *
 * @return array
 */

function compact_register_meta_boxes( $meta_boxes ) {

	$prefix = '_cmb_';

	// Post format
	$meta_boxes[] = array(
		'id'       => 'format_detail',
		'title'    => esc_html__( 'Format Details', 'compact' ),
		'pages'    => array( 'post' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields'   => array(
			array(
				'name'  => esc_html__( 'Background Header', 'compact' ),
				'id'    => $prefix . 'bg_header',
				'type'  => 'image_advanced',
				'max_file_uploads' => 1,
			),
			array(
				'name'             => esc_html__( 'Image', 'compact' ),
				'id'               => $prefix . 'image',
				'type'             => 'image_advanced',
				'class'            => 'image',
				'max_file_uploads' => 1,
			),
			array(
				'name'  => esc_html__( 'Gallery', 'compact' ),
				'id'    => $prefix . 'images',
				'type'  => 'image_advanced',
				'class' => 'gallery',
			),
			array(
				'name'  => esc_html__( 'Quote', 'compact' ),
				'id'    => $prefix . 'quote',
				'type'  => 'textarea',
				'cols'  => 20,
				'rows'  => 2,
				'class' => 'quote',
			),
			array(
				'name'  => esc_html__( 'Author', 'compact' ),
				'id'    => $prefix . 'quote_author',
				'type'  => 'text',
				'class' => 'quote',
			),
			array(
				'name'  => esc_html__( 'Audio', 'compact' ),
				'id'    => $prefix . 'link_audio',
				'type'  => 'textarea',
				'cols'  => 20,
				'rows'  => 2,
				'class' => 'audio',
				'desc' => 'Ex: https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/139083759',
			),
			array(
				'name'  => esc_html__( 'Video', 'compact' ),
				'id'    => $prefix . 'link_video',
				'type'  => 'textarea',
				'cols'  => 20,
				'rows'  => 2,
				'class' => 'video',
				'desc' => 'Example: <b>http://www.youtube.com/embed/0ecv0bT9DEo</b> or <b>http://player.vimeo.com/video/47355798</b>',
			),			
		),
	);

	$meta_boxes[] = array(
		'id'       => 'testi_dt',
		'title'    => esc_html__( 'Testimonial Details', 'compact' ),
		'pages'    => array( 'testimonial' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields'   => array(				
			array(
				'name'  => esc_html__( 'Location', 'compact' ),
				'id'    => $prefix . 'location',
				'type'  => 'text',
			),	
		),
	);

	$meta_boxes[] = array(
		'id'       => 'page_dt',
		'title'    => esc_html__( 'Page Details', 'compact' ),
		'pages'    => array( 'page' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields'   => array(			
			array(
				'name'  => esc_html__( 'Background Header', 'compact' ),
				'id'    => $prefix . 'bg_header',
				'type'  => 'image_advanced',
				'max_file_uploads' => 1,
			),	
		),
	);

	return $meta_boxes;
}
add_filter( 'rwmb_meta_boxes', 'compact_register_meta_boxes' );

