<?php global $compact_option; ?>
<header class="site-header-2 site-header">
        
    <div id="sticked-menu" class="sticky-header">
        <!-- Main bar start -->
        <div class="main-bar">
            <div class="container">                
                <div class="row">                    
                    <div class="col-md-12">

                        <!-- logo begin -->
                        <?php if($compact_option['logo'] != '') { ?>
                            <div id="logo" class="pull-left">                            
                                <a href="<?php echo esc_url( home_url('/') ); ?>">
                                    <img src="<?php echo esc_url($compact_option['logo']['url']); ?>" alt="" class="logo">
                                </a>
                            </div>
                        <?php } ?>
                        <!-- logo close -->

                        <!-- btn-mobile menu begin -->
                        <a id="show-mobile-menu" class="btn-mobile-menu hidden-lg hidden-md"><i class="fa fa-bars"></i></a>
                        <!-- btn-mobile menu close --> 

                        <!-- Header Group Button Right begin -->
                        <div class="header-buttons pull-right hidden-xs">
                            <?php if($compact_option['header_infos'] != ''){ ?>
                                <div class="header-contact">
                                    <?php echo wp_kses( $compact_option['header_infos'], wp_kses_allowed_html('post') ); ?>
                                </div>
                            <?php } ?>

                            <?php if (class_exists('Woocommerce')) { ?>
                                <div class="cart-button hidden-sm">
                                    <a href="#" class="dropdown-toggle cart-contents" data-toggle="dropdown"><i class="fa fa-shopping-bag"></i> <span class="mini-cart-counter">0</span></a>

                                    <div class="dropdown-menu top_cart_list_product">
                                        <?php woocommerce_mini_cart(); ?>
                                    </div>
                                </div>
                            <?php } ?>
                            
                            <?php if($compact_option['menu_right'] == true){ ?>
                                <!-- Button For Menu OffCanvas right begin -->
                                <div class="navright-button hidden-sm">
                                    <a href="" id="btn-offcanvas-menu"><i class="fa fa-bars"></i></a>                                        
                                </div> 
                                <!-- Button For Menu OffCanvas right close -->
                            <?php } ?>
                            
                        </div>
                        <!-- Header Group Button Right close -->

                        <!-- mobile menu begin -->
                        <nav id="mobile-menu" class="site-mobile-menu hidden-lg hidden-md">
                            <ul></ul>
                        </nav>  
                        <!-- mobile menu close -->    

                    </div>
                </div>
            </div>
        </div>

        <div class="sub-header">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <!-- desktop menu begin -->
                        <nav id="desktop-menu" class="site-desktop-menu site-desktop-menu-2 hidden-xs hidden-sm">
                            <?php
                                $topmenu = array(
                                    'theme_location'  => 'primary',
                                    'menu'            => '',
                                    'container'       => '',
                                    'container_class' => '',
                                    'container_id'    => '',
                                    'menu_class'      => 'clearfix',
                                    'menu_id'         => '',
                                    'echo'            => true,
                                    'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                                    'walker'          => new wp_bootstrap_navwalker(),
                                    'before'          => '',
                                    'after'           => '',
                                    'link_before'     => '',
                                    'link_after'      => '',
                                    'items_wrap'      => '<ul data-breakpoint="800" id="%1$s" class="%2$s">%3$s</ul>',
                                    'depth'           => 0,
                                );
                                if ( has_nav_menu( 'primary' ) ) {
                                    wp_nav_menu( $topmenu );
                                }
                            ?>
                        </nav>
                        <!-- desktop menu close --> 
                        <?php if($compact_option['search_head'] == true){ ?>
                            <div class="search-bar pull-right">                                
                                <?php get_search_form(); ?>                                        
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>                               
        </div>
    </div>
</header>
<div class="gray-line gray-line-2"></div>

<!-- Menu OffCanvas right begin -->
<?php if($compact_option['menu_right'] == true){ ?>
    <div class="navright-button hidden-sm">
        <div class="compact-menu-canvas" id="offcanvas-menu">
             <?php if($compact_option['title_menu_right'] != ''){ ?><h3><?php echo esc_attr($compact_option['title_menu_right']); ?><?php } ?></h3><a id="btn-close-canvasmenu"><i class="fa fa-close"></i></a>
            <nav>
            <?php
                $topmenu = array(
                    'theme_location'  => 'other',
                    'menu'            => '',
                    'container'       => '',
                    'container_class' => '',
                    'container_id'    => '',
                    'menu_class'      => 'clearfix',
                    'menu_id'         => '',
                    'echo'            => true,
                    'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                    'walker'          => new wp_bootstrap_navwalker(),
                    'before'          => '',
                    'after'           => '',
                    'link_before'     => '',
                    'link_after'      => '',
                    'items_wrap'      => '<ul data-breakpoint="800" id="%1$s" class="%2$s">%3$s</ul>',
                    'depth'           => 0,
                );
                if ( has_nav_menu( 'other' ) ) {
                    wp_nav_menu( $topmenu );
                }
            ?>                       
            </nav>
        </div>
    </div> 
<?php } ?>