<?php
/**
 * The template for displaying the footer
 */
 global $compact_option; 
?>

    <!-- FOOTER -->
    <footer class="footer-2 bg-color-2">

        <!-- main footer begin -->
        <div class="main-footer">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <img class="logo-footer" src="<?php echo esc_url($compact_option['logo_footer']['url']); ?>" alt="compact company">
                        <?php echo wp_kses($compact_option['footer_content'] , wp_kses_allowed_html('post')); ?>
                        <div class="footer-contact">
                            <?php echo wp_kses($compact_option['footer-contact'] , wp_kses_allowed_html('post')); ?>
                        </div>
                        <div class="social-icons-2 clearfix">
                            <?php 
                                if (isset($compact_option['social-list']) && !empty($compact_option['social-list'])) {
                                    foreach ($compact_option['social-list'] as $idx => $arr) {                                
                                        echo '<a href="' . $arr['url'] . '" class="' . $arr['description'] . ' tipped" data-title="' . $arr['title'] . '" data-tipper-options="{"direction":"top","follow":"true"}" ><i class="fa fa-' . $arr['description'] . '"></i></a>';
                                    }
                                }
                            ?>
                        </div>                           
                    </div>
                </div>
            </div>
        </div>            
        <!-- main footer close -->

        <!-- sub footer begin -->
        <div class="sub-footer">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <?php echo wp_kses( $compact_option['fcopyright'], wp_kses_allowed_html('post') ); ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- sub footer close -->

    </footer>
    <!-- footer close -->   
</div><!-- #wrapper -->
<a id="to-the-top" ><i class="fa fa-angle-up"></i></a>
<!-- END FOOTER -->
