<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
    return;
?>
<?php if ( have_comments() ) : ?>
<ol class="commentlist">
            <?php wp_list_comments('callback=compact_theme_comment'); ?>
        <?php
            // Are there comments to navigate through?
            if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
        ?>
            <nav class="navigation comment-navigation" role="navigation">          
                <div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'compact' ) ); ?></div>
                <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'compact' ) ); ?></div>
            </nav><!-- .comment-navigation -->
        <?php endif; // Check for comment navigation ?>

        <?php if ( ! comments_open() && get_comments_number() ) : ?>
            <p class="no-comments"><?php esc_html_e( 'Comments are closed.' , 'compact' ); ?></p>
        <?php endif; ?> 
</ol>
<?php endif; ?>     

<div class="comment-respond" id="respond">
        <?php
            if ( is_singular() ) wp_enqueue_script( "comment-reply" );
                $aria_req = ( $req ? " aria-required='true'" : '' );
                $comment_args = array(
                        'id_form' => 'commentform', 
                        'class_form' => 'comment-form material',                               
                        'title_reply'=> '<h2 class="comment-reply-title" id="reply-title">Levea a Reply</h2>',
                        'fields' => apply_filters( 'comment_form_default_fields', array(
                            'author' => '<p class="comment-form-author"><input id="author" name="author" type="text" placeholder="Name*" value="" size="30"/></p>',
                            'email' => '<p class="comment-form-email"><input id="email" name="email" type="email" placeholder="Email*" value="" size="30"/></p>', 
                            'website' => '<p class="comment-form-url"><input id="url" name="url" type="url" placeholder="Website" value="" size="30"/></p>',
                            
                        ) ),                                
                         'comment_field' => '<p class="comment-form-comment"><textarea id="comment" name="comment" cols="45" rows="8" placeholder="Comment*"></textarea></p>',                                                   
                         'label_submit' => esc_html__( 'Post Comment', 'compact' ),
                         'comment_notes_before' => '<p class="comment-notes"><span id="email-notes">You must be logged in to post a comment.</span><span class="required">*</span></p>',
                         'comment_notes_after' => '',  
                         'class_submit' => 'submit',             
                )
            ?>
            <?php comment_form($comment_args); ?>
</div><!-- //LEAVE A COMMENT -->
                