<?php

// Buttons
add_shortcode('button', 'button_func');
function button_func($atts, $content = null){
	extract(shortcode_atts(array(
		'btntext' 	=> '',
		'btnlink' 	=> '',
	), $atts));
	ob_start(); ?>

  <a href="<?php echo esc_url($btnlink); ?>" class="btn btn-primary btn-small"><?php echo esc_attr($btntext); ?></a>
  
<?php 
  return ob_get_clean();
}

// Buttons 2
add_shortcode('button2', 'button2_func');
function button2_func($atts, $content = null){
  extract(shortcode_atts(array(
    'btntext'   => '',
    'btnlink'   => '',
    'icon'      => '',
    'type'      => '',
    'color'     => '',
    'size'      => '',
    'mleft'     => '',
    'radius'    => '',
  ), $atts));

  ob_start(); ?>
  <?php 
    $color2 = '';
    $type2 = '';
    $size2 = '';
    $rad   = '';
    $left  = '';
    if($color == 'green'){
      $color2 = ' green';
    }elseif($color == 'orange'){
      $color2 = ' orange';
    }elseif($color == 'red'){
      $color2 = ' red';
    }elseif($color == 'yellow'){
      $color2 = ' yellow';
    }elseif($color == 'gray'){
      $color2 = ' grey';
    }elseif($color == 'black'){
      $color2 = ' black';
    }
    else{'';}
    if($type == 'true'){
      $type2 = ' btn-border-grey';
    }else{$type2 = ' btn-primary';}
    if($mleft == 'true'){
      $left = ' mleft';
    }
    if($size == 'small'){
      $size2 = ' btn-small';
    }elseif($size == 'large'){
      $size2 = ' width';
    }
    if($radius == 'radius50'){
      $rad = ' btn-radius';
    }elseif($radius == 'no-radius'){$rad = ' no-radius';}
    else{'';}
  ?>
  <a href="<?php esc_url($btnlink); ?>" type="button" class="btn<?php echo esc_attr($rad.$size2.$type2.$left.$color2); ?>"><?php if($icon != ''){ ?><i class="<?php echo esc_attr($icon); ?>"></i><?php } ?><?php echo esc_attr($btntext); ?></a>
<?php 
  return ob_get_clean();
}

// OT Separator
add_shortcode('ot_separator', 'ot_separator_func');
function ot_separator_func($atts, $content = null){
  extract(shortcode_atts(array(
    'bordercolor'   => '#999999',
    'alignment'   => 'left',
    'borderstyle'   => 'solid',
    'borderwidth'   => '2px',
    'elementwidth'   => '40px',
    'extraclass'  => ''
  ), $atts));
  ob_start(); ?>

  <div class="text-<?php echo esc_attr($alignment); ?>">
    <div class="separator-border <?php echo esc_attr($extraclass); ?>" style="margin: 0px 0 20px 0;width: <?php echo esc_attr($elementwidth); ?>;border-top-width: <?php echo esc_attr($borderwidth); ?>;border-top-color: <?php echo esc_attr($bordercolor); ?>;border-top-style: <?php echo esc_attr($borderstyle); ?>;clear: both;"></div>
  </div>
  
<?php 
  return ob_get_clean();
}

// Portfolios Slide
add_shortcode('latestpj', 'latestpj_func');
function latestpj_func($atts, $content = null){
  extract(shortcode_atts(array(
    'title'   =>  '',
    'number'     =>  '',
    'style'    => 'style1',
  ), $atts));

  ob_start(); ?>

  <?php if($style == 'style1'){ ?>
  <div class="latest-projects clearfix">
    <div class="latest-projects-intro">
        <?php if($title != ''){ ?><h2 class="box-title"><?php echo esc_attr($title); ?></h2><?php } ?>
        <div class="tiny-border-light"></div>            
        <?php if($content != ''){ ?><p><?php echo htmlspecialchars_decode($content); ?></p><?php } ?>        
    </div>
    <div class="latest-projects-wrapper">
    <div id="latest-projects-items" class="latest-projects-items">
  <?php }else{ ?>

  <div class="latest-projects-wrapper">
    <div class="text-center">
        <h2 class="box-title"><?php echo esc_attr($title); ?></h2>                                
        <div class="tiny-border"></div>
    </div>
    <div id="latest-projects-items-2" class="latest-projects-items">
  
  <?php } ?>

  <?php 
    $number1 = (!empty($number)) ? $number : 9;
    $args = array(   
        'post_type' => 'portfolio',
        'posts_per_page' => $number1,   
    );  
    $wp_query = new WP_Query($args);    
    if($wp_query->have_posts()):        
    while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
    $cates = get_the_terms(get_the_ID(),'categories');
       $cate_name ='';
       $cate_slug = '';
          foreach((array)$cates as $cate){
         if(count($cates)>0){
          $cate_name .= $cate->name.' ' ;
          $cate_slug .= $cate->slug .' ';     
         } 
       }              
  ?>    

      <div class="item">
        <?php the_post_thumbnail( 'full', array( 'class' => 'img-responsive' ) ); ?>
        <div class="project-details">
            <p class="folio-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
            <p class="folio-cate"><i class="fa fa-tag"></i>
              <?php             
                $terms = get_the_terms(get_the_ID(),'categories');
                //echo '<ul>';
                foreach ( $terms as $term ) {                               
                    // The $term is an object, so we don't need to specify the $taxonomy.
                    $term_link = get_term_link( $term );
                   
                    // If there was an error, continue to the next term.
                    if ( is_wp_error( $term_link ) ) {
                        continue;
                    }

                    // We successfully got a link. Print it out.                
                    echo '<a href="' . esc_url( $term_link ) . '">' . $term->name . '</a><span>,</span> ';
                }

                //echo '</ul>';
              ?> 
            </p>
            <div class="folio-buttons">
                <a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id());; ?>" title="<?php the_title(); ?>" class="folio"><i class="fa fa-search"></i></a>
                <a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i></a>
            </div>
        </div>
      </div>
            
      <?php endwhile; endif; ?>
    </div>
  </div>
  <?php if($style =='style1'){ ?></div><?php } ?>

<?php
    return ob_get_clean();
}

// Portfolio filter 1
add_shortcode('portfoliocol','portfoliocol_func');
function portfoliocol_func($atts, $content = null){
    extract( shortcode_atts( array(       
      'all'           => '',
      'column'        => '2column',
      'number'        => '', 
  ), $atts ) );

  ob_start(); ?>

  <div class="row">
    <div id="portfolio-filter" class="project-grid-2">
        <ul id="filter">
            <li> <a href="#" class="current" data-filter="*" title=""> <?php echo esc_attr($all); ?></a> </li>
            <?php 
             $categories = get_terms('categories');   
             foreach( (array)$categories as $categorie){
              $cat_name = $categorie->name;
              $cat_slug = $categorie->slug;
             ?>
             <li><a href="#" data-filter=".<?php echo esc_attr($cat_slug); ?>"><?php echo esc_attr($cat_name); ?></a></li>
            <?php } ?>
        </ul>
    </div>          
    <div class="clearfix"></div>
    
    <div id="projects-grid" class="projects-boxes">
        <?php 
            $number1 = (!empty($number)) ? $number : 9;
            $args = array(   
                'post_type' => 'portfolio',
                'posts_per_page' => $number1,   
            );  
            $wp_query = new WP_Query($args);    
            if($wp_query->have_posts()):        
            while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
            $cates = get_the_terms(get_the_ID(),'categories');
            $cate_name ='';
            $cate_slug = '';
            foreach((array)$cates as $cate){
              if(count($cates)>0){
                $cate_name .= $cate->name.' ' ;
                $cate_slug .= $cate->slug .' ';     
              } 
            }
        ?>       
        <div class="project-item <?php if($column == '3column'){echo 'col-md-4 col-sm-6';} elseif($column == '4column') {echo'col-md-3 col-sm-6';}else{echo'col-md-6 col-sm-6';} ?> <?php echo esc_attr($cate_slug); ?>">
            <div class="project-item-inner">
                <?php the_post_thumbnail( 'full', array( 'class' => 'img-responsive' ) ); ?>
                <div class="project-details">
                    <p class="folio-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
                    <p class="folio-cate"><i class="fa fa-tag"></i>
                      <?php             
                        $terms = get_the_terms(get_the_ID(),'categories');
                        //echo '<ul>';
                        foreach ( $terms as $term ) {                               
                            // The $term is an object, so we don't need to specify the $taxonomy.
                            $term_link = get_term_link( $term );
                           
                            // If there was an error, continue to the next term.
                            if ( is_wp_error( $term_link ) ) {
                                continue;
                            }

                            // We successfully got a link. Print it out.                
                            echo '<a href="' . esc_url( $term_link ) . '">' . $term->name . '</a><span>,</span> ';
                        }

                        //echo '</ul>';
                      ?> 
                    </p>
                    <div class="folio-buttons">
                        <a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id());; ?>" title="Plan For Your Bussiness" class="folio"><i class="fa fa-search"></i></a>
                        <a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i></a>
                    </div>
                </div>
            </div>
        </div>           
        <?php endwhile; wp_reset_postdata(); endif; ?>
    </div> 
  </div>

<?php
  return ob_get_clean();
}

// Portfolio filter 2
add_shortcode('portfoliocol2','portfoliocol2_func');
function portfoliocol2_func($atts, $content = null){
    extract( shortcode_atts( array(       
      'all'           => '',
      'column'        => '2column',
      'number'        => '', 
  ), $atts ) );

  ob_start(); ?>

  <div id="portfolio-filter" class="project-page">
      <ul id="filter">
          <li> <a href="#" class="current" data-filter="*" title=""> <?php echo esc_attr($all); ?></a> </li>
          <?php 
           $categories = get_terms('categories');   
           foreach( (array)$categories as $categorie){
            $cat_name = $categorie->name;
            $cat_slug = $categorie->slug;
           ?>
           <li><a href="#" data-filter=".<?php echo esc_attr($cat_slug); ?>"><?php echo esc_attr($cat_name); ?></a></li>
          <?php } ?>
      </ul>
  </div>          
  <div class="clearfix"></div>
  
  <div id="projects-grid" class="<?php if($column == '3column'){echo 'projects-grid-3';} elseif($column == '4column') {echo'projects-grid-4';}elseif($column == '5column'){echo'projects-grid-5';}else{echo 'projects-grid-2';} ?>">
      <?php 
          $number1 = (!empty($number)) ? $number : 9;
          $args = array(   
              'post_type' => 'portfolio',
              'posts_per_page' => $number1,   
          );  
          $wp_query = new WP_Query($args);    
          if($wp_query->have_posts()):        
          while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
          $cates = get_the_terms(get_the_ID(),'categories');
          $cate_name ='';
          $cate_slug = '';
          foreach((array)$cates as $cate){
            if(count($cates)>0){
              $cate_name .= $cate->name.' ' ;
              $cate_slug .= $cate->slug .' ';     
            } 
          }
      ?>       
      <div class="project-item <?php echo esc_attr($cate_slug); ?>">
          <div class="project-item-inner">
              <?php the_post_thumbnail( 'full', array( 'class' => 'img-responsive' ) ); ?>
              <div class="project-details">
                  <p class="folio-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
                  <p class="folio-cate"><i class="fa fa-tag"></i>
                    <?php             
                      $terms = get_the_terms(get_the_ID(),'categories');
                      //echo '<ul>';
                      foreach ( $terms as $term ) {                               
                          // The $term is an object, so we don't need to specify the $taxonomy.
                          $term_link = get_term_link( $term );
                         
                          // If there was an error, continue to the next term.
                          if ( is_wp_error( $term_link ) ) {
                              continue;
                          }

                          // We successfully got a link. Print it out.                
                          echo '<a href="' . esc_url( $term_link ) . '">' . $term->name . '</a><span>,</span> ';
                      }

                      //echo '</ul>';
                    ?> 
                  </p>
                  <div class="folio-buttons">
                      <a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id());; ?>" title="Plan For Your Bussiness" class="folio"><i class="fa fa-search"></i></a>
                      <a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i></a>
                  </div>
              </div>
          </div>
      </div>           
      <?php endwhile; wp_reset_postdata(); endif; ?>
  </div> 

<?php
  return ob_get_clean();
}

// Portfolio filter 3
add_shortcode('portfoliocol3','portfoliocol3_func');
function portfoliocol3_func($atts, $content = null){
    extract( shortcode_atts( array(   
      'title'         => '',
      'all'           => '',
      'number'        => '',
      'column'        => '2column',
   ), $atts ) );

    ob_start(); ?>

    <?php if($title != ''){ ?>
      <div class="pull-left">
          <h2 class="box-title"><?php echo esc_attr($title); ?></h2>                                
          <div class="tiny-border"></div>
      </div>
    <?php } ?>
    <div id="portfolio-filter" class="project-page pull-right">
        <ul id="filter">
            <li> <a href="#" class="current" data-filter="*" title=""> <?php echo esc_attr($all); ?></a> </li>
            <?php 
             $categories = get_terms('categories');   
             foreach( (array)$categories as $categorie){
              $cat_name = $categorie->name;
              $cat_slug = $categorie->slug;
             ?>
             <li><a href="#" data-filter=".<?php echo esc_attr($cat_slug); ?>"><?php echo esc_attr($cat_name); ?></a></li>
            <?php } ?>
        </ul>
    </div>          
    <div class="clearfix"></div>
    
    <div id="projects-grid" class="<?php if($column == '3column'){echo 'projects-grid-3';} elseif($column == '4column') {echo'projects-grid-4';}elseif($column == '5column'){echo'projects-grid-5';}else{echo 'projects-grid-2';} ?>">
        <?php 
          $number1 = (!empty($number)) ? $number : 9;
          $args = array(   
              'post_type' => 'portfolio',
              'posts_per_page' => $number1,   

          );  
          $wp_query = new WP_Query($args);    
          if($wp_query->have_posts()):        
          while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
          $cates = get_the_terms(get_the_ID(),'categories');
            $cate_name ='';
            $cate_slug = '';
            foreach((array)$cates as $cate){
               if(count($cates)>0){
                $cate_name .= $cate->name.' ' ;
                $cate_slug .= $cate->slug .' ';     
               } 
            }

        ?>       
          <div class="project-item <?php echo esc_attr($cate_slug); ?>">
              <div class="project-item-inner">
                  <?php the_post_thumbnail( 'full', array( 'class' => 'img-responsive' ) ); ?>
                  <div class="project-details">
                      <p class="folio-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
                      <p class="folio-cate"><i class="fa fa-tag"></i>
                        <?php             
                          $terms = get_the_terms(get_the_ID(),'categories');
                          //echo '<ul>';
                          foreach ( $terms as $term ) {                               
                              // The $term is an object, so we don't need to specify the $taxonomy.
                              $term_link = get_term_link( $term );
                             
                              // If there was an error, continue to the next term.
                              if ( is_wp_error( $term_link ) ) {
                                  continue;
                              }

                              // We successfully got a link. Print it out.                
                              echo '<a href="' . esc_url( $term_link ) . '">' . $term->name . '</a><span>,</span> ';
                          }
                          //echo '</ul>';
                        ?>  
                      </p>
                      <div class="folio-buttons">
                          <a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id());; ?>" title="Plan For Your Bussiness" class="folio"><i class="fa fa-search"></i></a>
                          <a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i></a>
                      </div>
                  </div>
              </div>
          </div>                                     
        <?php endwhile;?>
        <?php wp_reset_postdata(); ?>
        <?php endif; ?> 
    </div>          
    
<?php
    return ob_get_clean();
}

// Latest Blog 1
add_shortcode('latesblog1', 'latesblog1_func');
function latesblog1_func($atts, $content = null){
    extract(shortcode_atts(array(
        'title'   =>  '',
        'number'    => '',
        'visible'    => 'visible1',
    ), $atts));
    $number1 = (!empty($number)) ? $number : 4;
    ob_start(); ?>

    <div class="latest-blog-posts">
      <h2 class="box-title"><?php echo esc_attr($title); ?></h2>
      <div class="compact-buttons">
        <div class="latest-prev compact-prev"><i class="fa fa-angle-left"></i></div>
        <div class="latest-next compact-next"><i class="fa fa-angle-right"></i></div>
      </div>
      <div class="tiny-border"></div>

      <div class=" <?php if ($visible == 'visible2') {echo 'latest-news-items-3 row';}else{echo 'latest-news-items';} ?>">
        <?php 
            $args = array(   
                'post_type' => 'post',   
                'posts_per_page' => $number1,
            );  
            $wp_query = new WP_Query($args);
            while($wp_query->have_posts()) : $wp_query->the_post(); 
        ?>
          <?php $format = get_post_format();?>
          <div class="item">
              <div class="latest-blog-post-img">
                  <?php the_post_thumbnail( 'full', array( 'class' => 'img-responsive' ) ); ?>
                  <div class="latest-blog-post-date">
                      <?php the_time('d') ?> <span><?php the_time('M') ?></span>
                  </div>
              </div>
              <div class="latest-blog-post-details">
                  <p class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
                  <p><?php echo compact_excerpt(); ?></p>
                  <div class="latest-blog-post-data">
                      <?php if(has_category()) { ?><span class="tags"><i class="fa fa-tags"></i> <?php the_category( ', ' ); ?></span><?php } ?>
                      <span class="btn-read"><a href="<?php the_permalink(); ?>"><i class="fa fa-plus-square"></i> <?php esc_html_e('Read more', 'otvcp-i10n'); ?></a></span>
                  </div>
              </div>                                            
          </div>  
        <?php endwhile; ?>
        <?php wp_reset_postdata(); ?>
      </div>
    </div>

<?php 
  return ob_get_clean();
}

// Latest Blog 2
add_shortcode('latesblog2', 'latesblog2_func');
function latesblog2_func($atts, $content = null){
    extract(shortcode_atts(array(
        'title'   =>  '',
        'number'    => '',
    ), $atts));
    $number1 = (!empty($number)) ? $number : 4;
    ob_start(); ?>

  <div class="latest-blog-posts">
      <div class="text-center">
          <h2 class="box-title"><?php echo esc_attr($title); ?></h2>                                
          <div class="tiny-border"></div>
      </div>
    <div class="latest-news-items-2 row">
      <?php 

          $args = array(   
              'post_type' => 'post',   
              'posts_per_page' => $number1,
          );  
          $wp_query = new WP_Query($args);
          while($wp_query->have_posts()) : $wp_query->the_post(); 

      ?>
        <?php $format = get_post_format();?>
        <div class="item margin_15">
            <div class="latest-blog-post-img">
                <?php the_post_thumbnail( 'full', array( 'class' => 'img-responsive' ) ); ?>
                <div class="latest-blog-post-date">
                    <?php the_time('d') ?> <span><?php the_time('M') ?></span>
                </div>
            </div>
            <div class="latest-blog-post-details">
                <p class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
                <p><?php echo compact_excerpt(); ?></p>
                <div class="latest-blog-post-data">
                    <?php if(has_category()) { ?><span class="tags"><i class="fa fa-tags"></i> <?php the_category( ', ' ); ?></span><?php } ?>
                    <span class="btn-read"><a href="<?php the_permalink(); ?>"><i class="fa fa-plus-square"></i> <?php echo esc_html_e('Read more','otvcp-i10n') ?></a></span>
                </div>
            </div>                                            
        </div>  
      <?php endwhile; ?>
      <?php wp_reset_postdata(); ?>
    </div>
  </div>

<?php 
  return ob_get_clean();
}

// Testimonial Silder
add_shortcode('testslide','testslide_func');
function testslide_func($atts, $content = null){
  extract(shortcode_atts(array(
    'title'  => '',
    'number'  => '',
    'style'   => 'style1',
  ), $atts));
  $number1 = (!empty($number)) ? $number : -1;
  ob_start(); ?>

<?php if($style == 'style1'){ ?>
<div class="testimonials-slider-wrapper">
    <h2 class="box-title"><?php echo esc_attr($title); ?></h2>
    <div class="compact-buttons">
        <div class="testi-prev compact-prev"><i class="fa fa-angle-left"></i></div>
        <div class="testi-next compact-next"><i class="fa fa-angle-right"></i></div>
    </div>
    <div class="tiny-border"></div>
    <div class="testimonials-slider">
        <?php
          $args = array(
            'post_type' => 'testimonial',
            'posts_per_page' => $number1,
          );

          $testimonial = new WP_Query($args);
          if($testimonial->have_posts()) : while($testimonial->have_posts()) : $testimonial->the_post();
          $location = get_post_meta(get_the_ID(),'_cmb_location', true);
        ?>

        <div class="item">
            <div class="testi-boxes">
                <blockquote>
                    <?php the_content(); ?>
                </blockquote>
                <div class="testi-info clearfix">
                    <?php the_post_thumbnail( 'full', array( 'class' => 'img-circle' ) ); ?>
                    <div class="testi-details">
                        <span><?php the_title(); ?></span>
                        <?php echo esc_attr($location); ?>
                    </div>
                </div>
            </div>   
        </div>
    <?php endwhile; wp_reset_postdata(); endif; ?>
  </div>
</div>

<?php }elseif($style == 'style2'){ ?>

 <div class="testimonials-slider-wrapper">
    <div class="text-center">
      <h2 class="box-title"><?php echo esc_attr($title); ?></h2>
      <div class="tiny-border"></div>
    </div>
    <div class="testimonials-slider-2 text-center">
        <?php
          $args = array(
            'post_type' => 'testimonial',
            'posts_per_page' => $number1,
          );

          $testimonial = new WP_Query($args);
          if($testimonial->have_posts()) : while($testimonial->have_posts()) : $testimonial->the_post();
          $location = get_post_meta(get_the_ID(),'_cmb_location', true);
        ?>

        <div class="item">
            <div class="testi-boxes">
                <div class="testi-info clearfix">
                    <?php the_post_thumbnail( 'full', array( 'class' => 'img-circle' ) ); ?>
                    <div class="testi-details">
                        <span><?php the_title(); ?></span>
                        <?php echo esc_attr($location); ?>
                    </div>
                </div>
                <blockquote>
                    <?php the_content(); ?>
                </blockquote>
                
            </div>   
        </div>
    <?php endwhile; wp_reset_postdata(); endif; ?>
  </div>
</div>

<?php }else{ ?>

   <div class="testimonials-slider-wrapper">
      <div class="col-md-12">
        <h2 class="box-title"><?php echo esc_attr($title); ?></h2>
        <div class="compact-buttons">
          <div class="testi-prev compact-prev"><i class="fa fa-angle-left"></i></div>
          <div class="testi-next compact-next"><i class="fa fa-angle-right"></i></div>
        </div>
        <div class="tiny-border"></div>
      </div>
      <div class="clearfix"></div>
    
      <div class="testimonials-slider-3">
        <?php
          $args = array(
            'post_type' => 'testimonial',
            'posts_per_page' => $number1,
          );

          $testimonial = new WP_Query($args);
          if($testimonial->have_posts()) : while($testimonial->have_posts()) : $testimonial->the_post();
          $location = get_post_meta(get_the_ID(),'_cmb_location', true);
        ?>
        <div class="item">
            <div class="testi-boxes">
                <blockquote>
                    <?php the_content(); ?>
                </blockquote>
                <div class="testi-info clearfix">
                    <?php the_post_thumbnail( 'full', array( 'class' => 'img-circle' ) ); ?>
                    <div class="testi-details">
                        <span><?php the_title(); ?></span>
                        <?php echo esc_attr($location); ?>
                    </div>
                </div>
            </div>   
        </div>
      <?php endwhile; wp_reset_postdata(); endif; ?>
    </div>
  </div>
<?php } ?>

<?php
    return ob_get_clean();
}

// Call To Action
add_shortcode('calltoaction', 'calltoaction_func');
function calltoaction_func($atts, $content = null){
  extract(shortcode_atts(array(
    'linkbox'     =>  '',
    'image'       =>  '',
  ), $atts));
    $img = wp_get_attachment_image_src($image,'full');
    $img = $img[0];
    $url = vc_build_link( $linkbox );
  ob_start(); ?>
  <section id="section-cta" <?php if($img){ ?>style="background-image:url(<?php echo esc_url($img); ?>)"<?php } ?>>
  <div class="sep-background-mask"></div>
  <div class="container">
    <div class="row">
      <div class="col-md-12">
      <div class="cal-to-action text-center">
          <span><?php echo htmlspecialchars_decode($content); ?></span>
          <?php if ( strlen( $linkbox ) > 0 && strlen( $url['url'] ) > 0 ) {
              echo '<a data-gal="m_PageScroll2id" data-ps2id-offset="78" class="btn btn-border-light" href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">' . esc_attr( $url['title'] ) . '</a>';
          } ?>
      </div>
      </div>
    </div>
  </div>
  </section>
<?php
    return ob_get_clean();
}

// Services
add_shortcode('services', 'services_func');
function services_func($atts, $content = null){
  extract(shortcode_atts(array(
    'title'   =>  '',
    'image'   =>  '',
  ), $atts));
  $img = wp_get_attachment_image_src($image,'full');
  $img = $img[0];

  ob_start(); ?>

  <div class="service-box">
    <img src="<?php echo esc_url($img); ?>" alt="" class="img-responsive">
        <div class="service-content">
          <h3><?php echo esc_attr($title); ?></h3>
          <p><?php echo htmlspecialchars_decode($content); ?></p>
        </div>
  </div> 

<?php
    return ob_get_clean();
}

// Skill
add_shortcode('skill2', 'skill2_func');
function skill2_func($atts, $content = null){
  extract(shortcode_atts(array(
    'title'   => '',
    'number'  => '',
    'bgcolor' => '',
  ), $atts));
  ob_start(); ?>

    <div class="skills-name"><?php echo esc_attr($title); ?></div>
    <div class="pro-bar-container pro-bar-margin"> 
        <div class="text-in-bar"><span class="counter-skills"><?php echo esc_attr($number); ?></span><?php echo esc_html__('%','otvcp-i10n'); ?></div>
        <div style="background-color:<?php echo esc_attr($bgcolor); ?>" class="pro-bar bar-<?php echo esc_attr($number); ?>" data-pro-bar-percent="<?php echo esc_attr($number); ?>"></div>
    </div>

<?php
    return ob_get_clean();
}

// Logos Client
add_shortcode('logos', 'logos_func');
function logos_func($atts, $content = null){
  extract(shortcode_atts(array(
    'title'     =>  '',
    'gallery'   =>  '',
    'style'     =>  'style1',
  ), $atts));

  ob_start(); ?>

  <?php if($style == 'style1'){ ?>

  <?php if($title != ''){ ?>
    <div class="text-center">
        <h2 class="box-title"><?php echo esc_attr($title); ?></h2>                                
        <div class="tiny-border"></div>
    </div>
  <?php } ?>
  <div id="client-logo" class="our-partner">
      <?php 
      $img_ids = explode(",",$gallery);
      foreach( $img_ids AS $img_id ){
      $meta = wp_prepare_attachment_for_js($img_id);
      $caption = $meta['caption'];
      $title = $meta['title'];  
      $description = $meta['description'];  
      $image_src = wp_get_attachment_image_src($img_id,''); ?>
        <?php if(!empty($caption)){ ?> 
          <div class="item"><a target="_blank" href="<?php echo esc_attr($caption); ?>">
              <img src="<?php echo esc_url( $image_src[0] ); ?>" alt="<?php echo esc_attr($title); ?>">
          </a></div>
        <?php }else{ ?>           
          <div class="item"><img src="<?php echo esc_url( $image_src[0] ); ?>" alt="<?php echo esc_attr($title); ?>"></div>
        <?php } ?>
      <?php } ?>
  </div> 

  <?php }else{ ?>

    <?php if($title != ''){ ?><h2 class="box-title inline"><?php echo esc_attr($title); ?></h2><?php } ?>  
      <div class="compact-buttons">
          <div class="partner-prev compact-prev"><i class="fa fa-angle-left"></i></div>
          <div class="partner-next compact-next"><i class="fa fa-angle-right"></i></div>
      </div>                             
      <div class="tiny-border"></div>
      <div id="client-logo" class="our-partner control-client-2">
          <?php 
          $img_ids = explode(",",$gallery);
          foreach( $img_ids AS $img_id ){
          $meta = wp_prepare_attachment_for_js($img_id);
          $caption = $meta['caption'];
          $title = $meta['title'];  
          $description = $meta['description'];  
          $image_src = wp_get_attachment_image_src($img_id,''); ?>
            <?php if(!empty($caption)){ ?> 
              <div class="item"><a target="_blank" href="<?php echo esc_attr($caption); ?>">
                  <img src="<?php echo esc_url( $image_src[0] ); ?>" alt="<?php echo esc_attr($title); ?>">
              </a></div>
            <?php }else{ ?>           
              <div class="item"><img src="<?php echo esc_url( $image_src[0] ); ?>" alt="<?php echo esc_attr($title); ?>"></div>
            <?php } ?>
          <?php } ?>
      </div> 

  <?php } ?>
<?php
    return ob_get_clean();
}

// background Youtube Video
add_shortcode('bgyoutube', 'bgyoutube_func');
function bgyoutube_func($atts, $content = null){
  extract(shortcode_atts(array(
    'image'     =>  '',
    'title'     =>  '',
    'linkvideo' =>  '',
  ), $atts));

    $img = wp_get_attachment_image_src($image,'full');
    $img = $img[0];

  ob_start(); ?>
  
    <div class="about-text-intro text-center">
      <h2 class="box-title"><?php echo esc_attr($title); ?></h2>
      <p><?php echo htmlspecialchars_decode($content); ?></p>
    </div>
    <div class="box-intro-video">
      <div id="overlay-video" class="overlay-video-intro">
          <img src="<?php echo esc_url($img); ?>" class="img-responsive" />
          <a href="<?php echo esc_url($linkvideo); ?>" class="btn-intro-video"><i class="fa fa-play"></i></a>
      </div>
      <div id="thevideo" style="display:none">
          <iframe id="someFrame" width="750" height="422" src="" frameborder="0" allowfullscreen></iframe>
      </div>
    </div>
<?php
    return ob_get_clean();
}

//Section Header
add_shortcode('sechead', 'sechead_func');
function sechead_func($atts, $content = null){
  extract(shortcode_atts(array(
    'title'     =>  '',
    'linkbox'  =>  '',
    'linkbox1'  =>  '',
  ), $atts));

    $url = vc_build_link( $linkbox );
    $url1 = vc_build_link( $linkbox1 );

  ob_start(); ?>

    <div class="service-text-intro text-center">
        <?php if($title != ''){ ?><h2 class="box-title"><?php echo esc_attr($title); ?></h2><?php } ?>
        <p><?php echo htmlspecialchars_decode($content); ?></p>
    </div> 
    <p class="text-center btn-service-intro">
      <?php if ( strlen( $linkbox ) > 0 && strlen( $url['url'] ) > 0 ) {
        echo '<a class="btn btn-primary btn-small" href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">' . esc_attr( $url['title'] ) . '</a>';
      } ?>
      <?php if ( strlen( $linkbox ) > 0 && strlen( $url1['url'] ) > 0 ) {
        echo '<a class="btn btn-third btn-small" href="' . esc_attr( $url1['url'] ) . '" title="' . esc_attr( $url1['title'] ) . '" target="' . ( strlen( $url1['target'] ) > 0 ? esc_attr( $url1['target'] ) : '_self' ) . '">' . esc_attr( $url1['title'] ) . '</a>';
      } ?>
    </p>

<?php
    return ob_get_clean();
}

// Our Team
add_shortcode('team', 'team_func');
function team_func($atts, $content = null){
  extract(shortcode_atts(array(
    'image'   => '',
    'name'    => '',
    'job'     => '',
    'icon1'   => '',
    'soc1'    => '',
    'icon2'   => '',
    'soc2'    => '',
    'icon3'   => '',
    'soc1'    => '',
  ), $atts));

    $img = wp_get_attachment_image_src($image,'full');
    $img = $img[0];

  ob_start(); ?>

  <div class="team-box">
      <div class="team-inner">
          <img src="<?php echo esc_url($img) ?>" alt="" class="img-circle">
          <div class="mask"></div>
          <ul class="team-social-list"> 
              <li><a href="<?php echo esc_url($soc1); ?>"><i class="<?php echo esc_attr($icon1) ?>"></i></a></li>                                   
              <li><a href="<?php echo esc_url($soc2); ?>"><i class="<?php echo esc_attr($icon2) ?>"></i></a></li>
              <li><a href="<?php echo esc_url($soc3); ?>"><i class="<?php echo esc_attr($icon3) ?>"></i></a></li>                                    
          </ul>
      </div>                                
      <h6><?php echo esc_attr($name); ?></h6>
      <div class="subtext"><?php echo esc_attr($job); ?></div>
  </div> 

<?php
    return ob_get_clean();
}

//Newsletters
add_shortcode('newsletter_compact', 'newsletter_func');
function newsletter_func($atts, $content = null){
  extract(shortcode_atts(array(
    'image'     => '',
    'title'     => '',
    'stitle'    => '',
    'btntext'   => '',      
  ), $atts));

    $img = wp_get_attachment_image_src($image,'full');
    $img = $img[0];

  ob_start(); ?>
  <section id="section-cta" style="background-image:url(<?php echo esc_url($img); ?>)">
      <div class="sep-background-mask"></div>
      <div class="container">
          <div class="row">
              <div class="quick_newsletter">
                  <div class="newsletter-info col-md-4 col-sm-4">
                      <h3><?php echo esc_attr($title); ?></h3> 
                      <p><?php echo esc_attr($stitle); ?></p>                          
                  </div>
                  <div class="newsletter-element">
                      <form  method="post" action="<?php echo esc_url( home_url( '/' ) ); ?>wp-content/plugins/newsletter/do/subscribe.php" >
                          <p class="col-md-3 col-sm-3"><input class="newsletter-firstname input-text" name="ne" type="text" placeholder="<?php echo esc_html_e('Your Name','otvcp-i10n'); ?>"></p>
                          <p class="col-md-3 col-sm-3"><input class="newsletter-email input-text" name="ne" type="email" placeholder="<?php echo esc_html_e('Enter email','otvcp-i10n'); ?>"></p>
                          <p class="col-md-2 col-sm-2"><button class="newsletter-submit btn" type="submit" ><i class="fa fa-paper-plane"></i> <?php echo esc_attr($btntext); ?></button></p>
                      </form>
                  </div>
              </div>                                                                   
          </div>
      </div>        
  </section>
<?php 
  return ob_get_clean();
}

// Gallery
add_shortcode('gallerypj','gallerypj_func');
function gallerypj_func($atts, $content = null){
extract(shortcode_atts(array(
    'gallery'   =>  '',

), $atts));

ob_start(); ?>

      <div class="project-slider">  
       
        <?php 
            $img_ids = explode(",",$gallery);
            foreach( $img_ids AS $img_id ){
            $meta = wp_prepare_attachment_for_js($img_id);
            $image_src = wp_get_attachment_image_src($img_id,''); 
        ?>
            <div class="item"><img src="<?php echo esc_url($image_src[0]); ?>" alt=""></div>
        <?php } ?>  
      </div>

    <?php
    return ob_get_clean();
}

//Socials
add_shortcode('socials', 'socials_func');
function socials_func($atts, $content = null){
  extract(shortcode_atts(array(
    'icon1'     =>  '',
    'link1'     =>  '',
    'icon2'     =>  '',
    'link2'     =>  '',
    'icon3'     =>  '',
    'link3'     =>  '',
    'icon4'     =>  '',
    'link4'     =>  '',
    'icon5'     =>  '',
    'link5'     =>  '',
    'icon6'     =>  '',
    'link6'     =>  '',

  ), $atts));

  ob_start(); ?>

  <div class="social-share clearfix padding-top-bottom-50">
      <?php if($icon1 != ''){ ?><a href="<?php echo esc_url($link1) ?>" ><i class="<?php echo esc_attr($icon1); ?>"></i></a><?php } ?>
      <?php if($icon2 != ''){ ?><a href="<?php echo esc_url($link2) ?>" ><i class="<?php echo esc_attr($icon2); ?>"></i></a><?php } ?>
      <?php if($icon3 != ''){ ?><a href="<?php echo esc_url($link3) ?>" ><i class="<?php echo esc_attr($icon3); ?>"></i></a><?php } ?>
      <?php if($icon4 != ''){ ?><a href="<?php echo esc_url($link4) ?>" ><i class="<?php echo esc_attr($icon4); ?>"></i></a><?php } ?>
      <?php if($icon5 != ''){ ?><a href="<?php echo esc_url($link5) ?>" ><i class="<?php echo esc_attr($icon5); ?>"></i></a><?php } ?>
      <?php if($icon6 != ''){ ?><a href="<?php echo esc_url($link6) ?>" ><i class="<?php echo esc_attr($icon6); ?>"></i></a><?php } ?>      
  </div>
  <?php

    return ob_get_clean();
}

// Features
add_shortcode('linhtinh', 'linhtinh_func');
function linhtinh_func($atts, $content = null){
  extract(shortcode_atts(array(
    'icon'            => '',
    'title'           => '',
    'margin_bottom'   => '',

  ), $atts));

  ob_start(); ?>

      <div class="feature" style="margin-bottom:<?php echo esc_attr($margin_bottom); ?>">
          <i class="<?php echo esc_attr($icon); ?>"></i>
          <h3><?php echo esc_attr($title); ?></h3>
          <p><?php echo htmlspecialchars_decode($content); ?></p>
      </div>
  <?php

    return ob_get_clean();
}

// Icon Box
add_shortcode('icbox', 'icbox_func');
function icbox_func($atts, $content = null){
  extract(shortcode_atts(array(
    'image'    =>  '',
    'title'    =>  '',
  ), $atts));

    $img = wp_get_attachment_image_src($image,'full');
    $img = $img[0];
    
  ob_start(); ?>

      <div class="service-box service-style2">
          <img src="<?php echo esc_url($img); ?>" alt="" class="img-responsive">
          <div class="service-content">
              <h3><?php echo esc_attr($title); ?></h3>
              <p><?php echo htmlspecialchars_decode($content); ?></p>
          </div>
      </div>
  <?php

    return ob_get_clean();
}

// Pricing Table
add_shortcode('pricingtable', 'pricingtable_func');
function pricingtable_func($atts, $content = null){
  extract(shortcode_atts(array(
    'featured' => '',
    'image'     => '',
    'title'    => '',
    'price'    => '',
    'unit'     => '',
    'per'      => '',
    'btn'      => '',
    'link'     => '',
    'style'    => 'style1',
  ), $atts));

    $img = wp_get_attachment_image_src($image,'full');
    $img = $img[0];

  ob_start(); ?>

  <?php if($style == 'style1'){ ?>

  <div class="pricing-item <?php if($featured == true){echo 'featured';}else{'';} ?>">                   
      <div class="plan-price">
          <sup><?php echo esc_attr($unit); ?></i></sup><?php echo esc_attr($price); ?>                                 
      </div>
      <div class="plan-name"><?php echo esc_attr($title); ?></div>
      <div class="plan-details">                                    
          <?php echo htmlspecialchars_decode($content); ?>
      </div>
      <p class="plan-btn"><a href="<?php echo esc_url($link); ?>" class="btn btn-primary"><?php echo esc_attr($btn); ?></a></p>
  </div>

  <?php }else{ ?>

  <div class="pricing-item pricing-table-2 col-one-third <?php if($featured == true){echo 'featured';}else{'';} ?>"> 
      <img src="<?php echo esc_url($img); ?>" alt="" class="img-responsive"> 
      <div class="plan-name"><?php echo esc_attr($title); ?></div>                 
      <div class="plan-price">
          <sup><?php echo esc_attr($unit); ?></sup><?php echo esc_attr($price); ?> <span><?php echo esc_attr($per); ?></span>                                 
      </div>
      
      <div class="plan-details">                                    
          <?php echo htmlspecialchars_decode($content); ?>
      </div>
      <p class="plan-btn"><a href="<?php echo esc_url($link); ?>" class="btn btn-primary"><?php echo esc_attr($btn); ?></a></p>
  </div>

  <?php } ?>
  <?php
    return ob_get_clean();
}


// Border
add_shortcode('pink', 'pink_func');
function pink_func($atts, $content = null){
  extract(shortcode_atts(array(

  ), $atts));

  ob_start(); ?>

  <div class="text-center">
      <div class="tiny-border"></div>
  </div>

  <?php

    return ob_get_clean();
}

// Google Map

add_shortcode('ggmap','ggmap_func');
function ggmap_func($atts, $content = null){
    extract( shortcode_atts( array(
      'idmap'    => 'map_canvas',
      'title'    => '', 
      'lat'      => '',
      'long'     => '',
      'zoom'     => '',
      'mapcolor' => '',
      'icon'     => '',
   ), $atts ) );
   
   $icon1 = wp_get_attachment_image_src($icon,'full');
   $icon1 = $icon1[0];
   
   if(!$zoom){
   	$zoom = 13;
   }
   		
    ob_start(); ?>
    	<section id="section-gmap" class="no-padding">                
          <div id="map-canvas" class="map-canvas"></div>       
      </section>
    

    <script type="text/javascript">
	  (function($) {
    "use strict"

    $(document).ready(function(){
          var latitude = <?php echo esc_attr($lat); ?>,
              longitude = <?php echo esc_attr($long); ?>,
              map_zoom = <?php echo esc_attr($zoom); ?>;

          var locations = [
              ['<div class="infobox"><span><?php echo esc_attr($title); ?></span></div>', latitude, longitude, 2]
          ];
      
          var map = new google.maps.Map(document.getElementById('map-canvas'), {
              zoom: map_zoom,
              scrollwheel: false,
              navigationControl: true,
              mapTypeControl: false,
              scaleControl: false,
              draggable: true,
              styles: [
                  {
                      "featureType": "water",
                      "elementType": "geometry",
                      "stylers": [
                          {
                              "color": "<?php echo esc_attr($mapcolor); ?>"
                          },
                          {
                              "lightness": 17
                          }
                      ]
                  },
                  {
                      "featureType": "landscape",
                      "elementType": "geometry",
                      "stylers": [
                          {
                              "color": "#f5f5f5"
                          },
                          {
                              "lightness": 20
                          }
                      ]
                  },
                  {
                      "featureType": "road.highway",
                      "elementType": "geometry.fill",
                      "stylers": [
                          {
                              "color": "#ffffff"
                          },
                          {
                              "lightness": 17
                          }
                      ]
                  },
                  {
                      "featureType": "road.highway",
                      "elementType": "geometry.stroke",
                      "stylers": [
                          {
                              "color": "#ffffff"
                          },
                          {
                              "lightness": 29
                          },
                          {
                              "weight": 0.2
                          }
                      ]
                  },
                  {
                      "featureType": "road.arterial",
                      "elementType": "geometry",
                      "stylers": [
                          {
                              "color": "#ffffff"
                          },
                          {
                              "lightness": 18
                          }
                      ]
                  },
                  {
                      "featureType": "road.local",
                      "elementType": "geometry",
                      "stylers": [
                          {
                              "color": "#ffffff"
                          },
                          {
                              "lightness": 16
                          }
                      ]
                  },
                  {
                      "featureType": "poi",
                      "elementType": "geometry",
                      "stylers": [
                          {
                              "color": "#f5f5f5"
                          },
                          {
                              "lightness": 21
                          }
                      ]
                  },
                  {
                      "featureType": "poi.park",
                      "elementType": "geometry",
                      "stylers": [
                          {
                              "color": "#dedede"
                          },
                          {
                              "lightness": 21
                          }
                      ]
                  },
                  {
                      "elementType": "labels.text.stroke",
                      "stylers": [
                          {
                              "visibility": "on"
                          },
                          {
                              "color": "#ffffff"
                          },
                          {
                              "lightness": 16
                          }
                      ]
                  },
                  {
                      "elementType": "labels.text.fill",
                      "stylers": [
                          {
                              "saturation": 36
                          },
                          {
                              "color": "#333333"
                          },
                          {
                              "lightness": 40
                          }
                      ]
                  },
                  {
                      "elementType": "labels.icon",
                      "stylers": [
                          {
                              "visibility": "off"
                          }
                      ]
                  },
                  {
                      "featureType": "transit",
                      "elementType": "geometry",
                      "stylers": [
                          {
                              "color": "#f2f2f2"
                          },
                          {
                              "lightness": 19
                          }
                      ]
                  },
                  {
                      "featureType": "administrative",
                      "elementType": "geometry.fill",
                      "stylers": [
                          {
                              "color": "#fefefe"
                          },
                          {
                              "lightness": 20
                          }
                      ]
                  },
                  {
                      "featureType": "administrative",
                      "elementType": "geometry.stroke",
                      "stylers": [
                          {
                              "color": "#fefefe"
                          },
                          {
                              "lightness": 17
                          },
                          {
                              "weight": 1.2
                          }
                      ]
                  }
              ],
              center: new google.maps.LatLng(latitude, longitude),
            mapTypeId: google.maps.MapTypeId.ROADMAP
          });
      
          var infowindow = new google.maps.InfoWindow();
      
          var marker, i;
      
          for (i = 0; i < locations.length; i++) {  
        
              marker = new google.maps.Marker({ 
                  position: new google.maps.LatLng(locations[i][1], locations[i][2]), 
                  map: map,
                  icon: '<?php echo esc_url($icon1); ?>'
              });
          
            google.maps.event.addListener(marker, 'click', (function(marker, i) {
              return function() {
                infowindow.setContent(locations[i][0]);
                infowindow.open(map, marker);
              }
            })(marker, i));
          }
          
      });
      })(jQuery);     
    </script>
<?php

    return ob_get_clean();

}