<?php $__env->startSection("css"); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', '| indicateur'); ?>


<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
        <div class="content-header">
                        <div class="container-fluid">
                            <div class="row mb-2">
                            <div class="col-sm-6">
                                <h1 class="m-0 text-info">Suivi des indicateurs <?php if($annee): ?>
                                    pour l'année <?php echo e($annee); ?>

                                <?php endif; ?>  </h1>
                            </div><!-- /.col -->
                            <div class="col-sm-6">
                                <ol class="breadcrumb float-sm-right">
                                    <li class="breadcrumb-item"><a href="<?php echo e(route('go.menu',['projet_id'=>$projet_id])); ?>" role="button" class="btn btn-success">Menu</a></li>
                                <li class="breadcrumb-item active"><a href="<?php echo e(route('indicateur.create')); ?>" role="button" class="btn btn-success">Enregistrer indicateur</a></li>
                                </ol>
                            </div><!-- /.col -->
                            </div><!-- /.row -->
                        </div><!-- /.container-fluid -->
            </div>

    <?php if($message = Session::get('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>
    <?php if($message = Session::get('error')): ?>
        <div class="alert alert-danger">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>

    <div class="col-md-12">
        <?php if($projet->typecadre=="Cadre de  resultat"): ?>
        <fieldset>
            <legend>Recherche par année:</legend>
          <form action="<?php echo e(route('search.resultat')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-sm-5">

                    <div class="form-group">
                        <label> Année:</label>

                        <div class="input-group">
                          <div class="input-group-prepend">
                            <span class="input-group-text">
                              <i class="far fa-calendar"></i>
                            </span>
                          </div>
                          <select class="form-control" name="annee" required="">
                            <option value="">Selectionnez</option>
                            <?php for($i=1; $i <= $projet->duree; $i++): ?>
                            <option value="<?php echo e($i); ?>">annee <?php echo e($i); ?></option>
                            <?php endfor; ?>

                        </select>
                        <input type="hidden" value="<?php echo e($projet->id); ?>" name="projet_id">
                          <button type="submit" class="btn btn-success btn btn-sm "> Rechercher</button>
                        </div>
                        <!-- /.input group -->
                      </div>
                    </div>
            </div>

          </form>
        </fieldset>
        <?php endif; ?>

            <form action="<?php echo e(route('search.periode.resultat')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group">
        <div class="col-sm-6">


            <input type="hidden" id="from" name="from"  value="<?php echo e(old('from')); ?>"  required>
            <input type="hidden" id="to" name="to"  value="<?php echo e(old('to')); ?>"  required>


                <div class="input-group">
                  <div class="input-group-prepend">
                    <label> Periode:</label>
                    <span class="input-group-text">
                      <i class="far fa-calendar-alt"></i>
                    </span>
                  </div>
                  <input type="text" name="daterange" class="form-control float-right" id="reservation">
                  <button type="submit" class="btn btn-success btn  "> Rechercher</button>
                </div>
                <!-- /.input group -->
              </div>


              <input id="projet_id" type="hidden" value="<?php echo e($projet->id); ?>" name="projet_id">
        </div>
        </form>

        <form action="<?php echo e(route('search.resultat.region')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label> Region:</label>

                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text">
                      <i class="far fa-map"></i>
                    </span>
                  </div>
                  <select class="form-control" name="region_id" required="">
                    <option value="">Selectionnez</option>
                    <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($region->id); ?>" > <?php echo e($region->nom); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </select>
                <input type="hidden" value="<?php echo e($projet->id); ?>" name="projet_id">
                  <button type="submit" class="btn btn-success btn btn-sm "> Rechercher</button>
                </div>
                <!-- /.input group -->
              </div>
    </form>

      </div>
    <div class="col-12">
        <div class="row">
            <?php $__currentLoopData = $indicateurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $indicateur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-4">
                    <p><?php echo e($indicateur->indicateur); ?></p>
                    <canvas id="myChart<?php echo e($key); ?>" width="400" height="400"></canvas>
                </div>
                
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <div class="card border-danger border-0">
        <div class="card-header bg-success text-center">LISTE D'ENREGISTREMENT DES INDICATEURS</div>
            <div class="card-body">
                <table id="example1" class="table table-bordered table-responsive-md table-striped text-center">
                    <thead>
                        <tr>

                            <th>Indicateur</th>
                            <th>Valeur Cible</th>
                            <th>Valeur atteinte</th>
                            <th>Ecart</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $indicateurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indicateur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($indicateur->indicateur); ?></td>
                            <td><?php echo e($indicateur->cible); ?></td>
                            <td><?php echo e($indicateur->sum ?  $indicateur->sum  : 0); ?></td>
                            <td><?php echo e($indicateur->sum - $indicateur->cible); ?></td>
                            <td>
                               
                                <a href="<?php echo e(route('indicateur.resultat', ['indicateur'=>$indicateur->id,'projet'=>$projet_id])); ?>" class="btn btn-info">Résultats</a>


                            </td>
                            

                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>

                

            </div>

        </div>


    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    <?php $__currentLoopData = $indicateurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $indicateur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


const ctx<?php echo e($key); ?> = document.getElementById('myChart<?php echo e($key); ?>').getContext('2d');
const myChart<?php echo e($key); ?> = new Chart(ctx<?php echo e($key); ?>, {
    type: 'bar',
    data: {
        labels: ['Indicateurs'],
        datasets: [{
          label: 'Valeur Cible',
          backgroundColor: 'rgba(255, 206, 86, 1)',
          data: ['<?php echo e($indicateur->cible); ?>']
        }, {
          label: 'Valeur Atteint',
          backgroundColor: 'rgba(0, 128, 0, 1)',
          data: ['<?php echo e($indicateur->sum ?  $indicateur->sum  : 0); ?>']
        }, {
          label: 'Valeur Ecart',
          backgroundColor:'rgba(255, 0, 0, 1)',
          data:[ '<?php echo e($indicateur->sum - $indicateur->cible); ?>']
        }]
      },

      options: {
        legend: {
          display: true,
          position: 'top',
          labels: {
            fontColor: "#000080",
          }
        },
        scales: {
          yAxes: [{
            ticks: {
              beginAtZero: true
            }
          }]
        }
      }
});

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script>
    $(function() {
        const currentDate = new Date();
        const currentDayOfMonth = currentDate.getDate();
        const currentMonth = currentDate.getMonth(); // Be careful! January is 0, not 1
        const currentYear = currentDate.getFullYear();

        $('#from').val( currentYear + "-" + (currentMonth + 1) + "-" + currentDayOfMonth  );
        $('#to').val(currentYear+ "-" + (currentMonth + 1) + "-" +  currentDayOfMonth  );
      $('input[name="daterange"]').daterangepicker({
        "locale": {
            "format": "DD/MM/YYYY",
            "separator": " - ",
            "applyLabel": "Appliquer",
            "cancelLabel": "Annuler",
            "fromLabel": "De",
            "toLabel": "A",
            "customRangeLabel": "Custom",
            "weekLabel": "S",
            "daysOfWeek": [
                "Di",
                "Lu",
                "Ma",
                "Me",
                "Je",
                "Ve",
                "Sa"
            ],
            "monthNames": [
                "Janvier",
                "Fevrier",
                "Mars",
                "Avril",
                "Mai",
                "Juin",
                "Juillet",
                "Auout",
                "Septembre",
                "Octobre",
                "Novembre",
                "Decembre"
            ]},
        opens: 'left'
      }, function(start, end, label) {
        console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
        $('#from').val(start.format('YYYY-MM-DD'));
        $('#to').val(end.format('YYYY-MM-DD'));
      });


    });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\enda\RFA\plateforme RFA\rfaBackend\resources\views/indicateur/fiche.blade.php ENDPATH**/ ?>