<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js"></script>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark"><?php echo e($projet->nom); ?></h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('go.menu', ['projet_id'=>$projet_id])); ?>">Accueil</a></li>
                        <li class="breadcrumb-item active">BIENVENUE</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
            <!-- Small boxes (Stat box) -->
            <div class="col-lg-3 col-6">
                <!-- small box -->
                <div class="small-box bg-warning">
                  <div class="inner">
                    <h3><?php echo e($nbActivite); ?></h3>

                    <p><b>Activités prévues</b></p>
                  </div>
                  <div class="icon">
                    <i class="ion ion-calendar"></i>
                  </div>
                </div>
              </div>
              <!-- ./col -->
            <div class="col-lg-3 col-6">
              <!-- small box -->
              <div class="small-box bg-success">
                <div class="inner">
                  <h3><?php echo e($nbSuiviActivite); ?></h3>

                  <p><b>Activités realisées</b></p>
                </div>
                <div class="icon">
                  <i class="ion ion-stats-bars"></i>
                </div>
              </div>
            </div>


            <div class="col-lg-3 col-6">
              <!-- small box -->
              <div class="small-box bg-danger">
                <div class="inner">
                  <h3><?php echo e($nbEcart); ?></h3>

                  <p><b>Activites non realisées</b></p>
                </div>
                <div class="icon">
                  <i class="ion ion-pie-graph"></i>
                </div>
              </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-6">
              <!-- small box -->
              <div class="small-box bg-success">
                <div class="inner">
                  <h3><?php echo e($nbActiviteNonPrevu); ?></h3>

                  <p><b>Activités non prévu realisées</b></p>
                </div>
                <div class="icon">
                  <i class="ion ion-stats-bars"></i>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-6"">
                <canvas id="myChart" width="100%" height="100%"></canvas>
            </div>
            <!-- ./col -->
          </div>
            <div class="row">
                <?php $__currentLoopData = $indicateurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $indicateur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-4">
                        <p><?php echo e($indicateur->indicateur); ?></p>
                        <canvas id="myChart<?php echo e($key); ?>" width="400" height="400"></canvas>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="row">
                <div class="col-12">

                    <div class="card border-danger border-0">
                        <div class="card-header bg-success text-center">Fiche de suivi des activités de <?php echo e($projet->nom); ?></div>
                            <div class="card-body">
                                <table id="example1" class="table table-bordered table-responsive-md table-striped text-center">
                                    <thead>
                                        <tr>
                                            <th>Activité</th>
                                            <th>Date</th>
                                            <th>Resultats obtenus</th>
                                            <th>Observation</th>
                                            <th>Niveau de réalisation</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $suiviActivites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $suiviActivite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($suiviActivite->noma); ?></td>
                                            <td><?php echo e($suiviActivite->dater); ?></td>
                                            <td><?php echo $suiviActivite->resultat; ?></td>
                                            <td><?php echo $suiviActivite->observation; ?></td>
                                            <td>
                                               <?php echo e($suiviActivite->niveaur); ?>

                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('suiviactivite.edit', [$suiviActivite->id,$projet->id])); ?>" role="button" class="btn btn-primary"><i class="fas fa-edit"></i></a>
                                                
                                                <?php echo Form::open(['method' => 'DELETE', 'route'=>['suiviActivite.destroy', $suiviActivite->id], 'style'=> 'display:inline', 'onclick'=>"if(!confirm('Êtes-vous sûr de vouloir supprimer cet enregistrement ?')) { return false; }"]); ?>

                                                <button class="btn btn-danger"><i class="far fa-trash-alt"></i></button>
                                                <?php echo Form::close(); ?>




                                            </td>

                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>



                            </div>

                        </div>
                    </div>
                    <div class="col-12">
                    <div class="card border-danger border-0">
                        <div class="card-header bg-success text-center">Fiche de suivi des indicateurs</div>
                            <div class="card-body">
                                <table id="example2" class="table table-bordered table-responsive-md table-striped text-center">
                                    <thead>
                                        <tr>

                                            <th>Indicateur</th>
                                            <th>Valeur Cible</th>
                                            <th>Valeur atteinte</th>
                                            <th>Ecart</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $indicateurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indicateur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($indicateur->indicateur); ?></td>
                                            <td><?php echo e($indicateur->cible); ?></td>
                                            <td><?php echo e($indicateur->sum ?  $indicateur->sum  : 0); ?></td>
                                            <td><?php echo e($indicateur->sum - $indicateur->cible); ?></td>
                                            <td>
                                               
                                                <a href="<?php echo e(route('indicateur.resultat', ['indicateur'=>$indicateur->id,'projet'=>$projet->id])); ?>" class="btn btn-info">Résultats</a>


                                            </td>
                                            

                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>



                            </div>

                        </div>


                    </div>
            </div>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-12">

                            <div id="address-map" style="height: 700px"></div>

                </div>
            </div>
    </section>
        </div>
        <input type="hidden" value="15.3893489" id="latitude">
        <input type="hidden" value="-14.7824247" id="longitude">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    <?php $__currentLoopData = $indicateurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $indicateur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


const ctx<?php echo e($key); ?> = document.getElementById('myChart<?php echo e($key); ?>').getContext('2d');
const myChart<?php echo e($key); ?> = new Chart(ctx<?php echo e($key); ?>, {
    type: 'bar',
    data: {
        labels: ['Indicateurs'],
        datasets: [{
          label: 'Valeur Cible',
          backgroundColor: 'rgba(255, 206, 86, 1)',
          data: ['<?php echo e($indicateur->cible); ?>']
        }, {
          label: 'Valeur Atteint',
          backgroundColor: 'rgba(0, 128, 0, 1)',
          data: ['<?php echo e($indicateur->sum ?  $indicateur->sum  : 0); ?>']
        }, {
          label: ' Valeur Ecart',
          backgroundColor:'rgba(255, 0, 0, 1)',
          data:[ '<?php echo e($indicateur->sum  - $indicateur->cible); ?>']
        }]
      },

      options: {
        legend: {
          display: true,
          position: 'top',
          labels: {
            fontColor: "#000080",
          }
        },
        scales: {
          yAxes: [{
            ticks: {
              beginAtZero: true
            }
          }]
        }
      }
});
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
const ctx = document.getElementById('myChart').getContext('2d');
const myChart = new Chart(ctx, {
    type: 'pie',
    data: {
        labels: ['Activités prévus', 'Activités realisé', 'Activites non realisé'],
        datasets: [{
            label: 'Activité',
            data: ['<?php echo e($nbActivite); ?>', '<?php echo e($nbSuiviActivite); ?>', '<?php echo e($nbEcart); ?>'],
            backgroundColor: [
                'rgba(255, 206, 86, 1)',
                'rgba(0, 128, 0, 1)',
                'rgba(255, 0, 0, 1)'
            ]
        }]
    },
    options: {
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
})


var map = L.map('address-map').setView([parseFloat(document.getElementById('latitude').value),parseFloat(document.getElementById('longitude').value)],8);
L.tileLayer('https://api.maptiler.com/maps/streets/256/{z}/{x}/{y}.png?key=r7UvRXibthwur7YWRkfQ',{
    attribution : '<a href="https://www.maptiler.com/copyright/" target="_blank">&copy; MapTiler</a> <a href="https://www.openstreetmap.org/copyright" target="_blank">&copy; OpenStreetMap contributors</a>'
}).addTo(map);
var greenIcon = L.icon({
    iconUrl: '<?php echo e(asset('assets/dist/img/danger.png')); ?>',


   iconSize:     [28, 30], // size of the icon
   
});
var redIcon = new L.Icon({
    iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-2x-red.png',
    shadowUrl: 'https://cdnjs.cloudflare.com/ajax/libs/leaflet/0.7.7/images/marker-shadow.png',
    iconSize: [25, 41],
    iconAnchor: [12, 41],
    popupAnchor: [1, -34],
    shadowSize: [41, 41]
  });

<?php $__currentLoopData = $listCommune; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php if( !empty($commune->latitude )): ?>
var marker = L.marker([parseFloat(<?php echo e($commune->latitude); ?>),parseFloat(<?php echo e($commune->longitude); ?> )]).addTo(map);
marker.bindPopup('  <h6> Commune de <?php echo e($commune->nomc); ?></h6><?php $__currentLoopData = $commune->indicateur; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indicateur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>'+
'<strong>Indicateur</strong> : <?php echo e($indicateur->indicateur); ?> <strong>(Valeur atteint : <?php echo e($indicateur->rts); ?>)</strong><br>'+
'<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>' ).openPopup();
<?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__currentLoopData = $listVillages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $village): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php if( !empty($village->latitude )): ?>
var marker = L.marker([parseFloat(<?php echo e($village->latitude); ?>),parseFloat(<?php echo e($village->longitude); ?> )], {icon: redIcon}).addTo(map);
marker.bindPopup('  <h6> Village/quartier de <?php echo e($village->nomv); ?></h6><?php $__currentLoopData = $village->indicateur; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indicateur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>'+
'<strong>Indicateur</strong> : <?php echo e($indicateur->indicateur); ?> <strong>(Valeur atteint : <?php echo e($indicateur->rts); ?>)</strong><br>'+
'<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>' ).openPopup();
<?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



</script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\enda\RFA\plateforme RFA\rfaBackend\resources\views/welcome.blade.php ENDPATH**/ ?>