<?php $__env->startSection('title', '| Modifier Région'); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">

        <div class="container">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-info">GESTION DES PROJETS</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>" role="button" class="btn btn-success">ACCUEIL</a></li>
                        <li class="breadcrumb-item active"><a href="<?php echo e(route('projet.index')); ?>" role="button" class="btn btn-success">RETOUR</a></li>

                        </ol>
                    </div><!-- /.col -->
                    </div><!-- /.row -->
                </div><!-- /.container-fluid -->
            </div>

        <?php echo Form::model($projet, ['method'=>'PATCH','route'=>['projet.update', $projet->id],'enctype'=>'multipart/form-data']); ?>

            <?php echo csrf_field(); ?>
             <div class="card border-danger border-0">
                        <div class="card-header bg-success text-center">FORMULAIRE DE MODIFICATION TABLE</div>
                            <div class="card-body">
                                <?php if($errors->any()): ?>
                                    <div class="alert alert-danger">
                                        <ul>
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>

                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Nom de la projet</label>
                                    <input type="text" name="nom" class="form-control" value="<?php echo e($projet->nom); ?>"   required>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Durée</label>
                                        <input type="number" name="duree"  value="<?php echo e($projet->duree); ?>" class="form-control"  required>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Objectif</label>
                                        <textarea name="objectif"  class="form-control" > <?php echo e($projet->objectif); ?></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Type Cadre</label>
                                        <select class="form-control" name="typecadre" required="">
                                            <option value="">Veuillez Selectionnez</option>
                                            <option value="Cadre logique" <?php echo e(old('typecadre', $projet->typecadre) == 'Cadre logique' ? 'selected' : ''); ?>>Cadre Logique</option>
                                            <option value="Cadre de  resultat"  <?php echo e(old('typecadre', $projet->typecadre) == 'Cadre de  resultat' ? 'selected' : ''); ?>>Cadre de  resultat</option>
                                            <option value="Plan d'action" <?php echo e(old('typecadre', $projet->typecadre) == 'Plan d\'action' ? 'selected' : ''); ?>>Plan d'action</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">

                                    <div class="form-group">
                                        <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <div class="custom-control custom-checkbox">
                                          <input class="custom-control-input" name="zone[]" type="checkbox" id="customCheckbox<?php echo e($region->id); ?>" value="<?php echo e($region->id); ?>"  <?php echo e($tab[$key] == true ? 'checked' : ''); ?>>
                                          <label for="customCheckbox<?php echo e($region->id); ?>" class="custom-control-label"><?php echo e($region->nom); ?></label>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>

                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Image en avant</label>
                                        <input type="file" name="image"  class="form-control" >
                                    </div>
                                </div>
                                <div>
                                    <center>
                                        <button type="submit" class="btn btn-success btn btn-lg "> MODIFIER</button>
                                    </center>
                                </div>


                            </div>
                        </div>
    <?php echo Form::close(); ?>

                </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\enda\RFA\plateforme RFA\rfaBackend\resources\views/projet/edit.blade.php ENDPATH**/ ?>