<?php $__env->startSection('calendar'); ?>
<link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.10.1/main.min.css' rel='stylesheet' />
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style>
    fieldset {
      background-color: #eeeeee;
      display: block;
      margin-left: 2px;
      margin-right: 2px;
      padding-top: 0.35em;
      padding-bottom: 0.625em;
      padding-left: 0.75em;
      padding-right: 0.75em;
      border: 2px groove (internal value);
    }

    legend {
      background-color: gray;
      color: white;
      padding: 5px 10px;
    }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
        <div class="content-header">
                        <div class="container-fluid">
                            <div class="row mb-2">
                            <div class="col-sm-6">
                                <h1 class="m-0 text-info">Liste des Activités de <?php echo e($projet->nom); ?></h1>
                            </div><!-- /.col -->
                            <div class="col-sm-6">
                                <ol class="breadcrumb float-sm-right">
                                    <li class="breadcrumb-item"><a href="<?php echo e(route('go.menu',['projet_id'=>$projet->id])); ?>" role="button" class="btn btn-success">Menu</a></li>
                                <li class="breadcrumb-item active"><a href="<?php echo e(route('activite.create')); ?>" role="button" class="btn btn-success">Liste des activités</a></li>
                                </ol>
                            </div><!-- /.col -->
                            </div><!-- /.row -->
                        </div><!-- /.container-fluid -->
            </div>

    <?php if($message = Session::get('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>
    <?php if($message = Session::get('error')): ?>
        <div class="alert alert-danger">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>

     
<div class="col-12">
    <div class="card border-danger border-0">
        <div class="card-header bg-success text-center">Nom Projet : <?php echo e($projet->nom); ?></div>
            <div class="card-body">
                <table id="example1" class="table table-bordered table-responsive-md table-striped text-center">
                    <thead>
                        <tr>
                            <th>Activité</th>
                            <th>Date Début</th>
                            <th>Date Fin</th>
                            <th>Responsable</th>
                            <th>Resultats attendus</th>
                             <th>Fiches de Collecte</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $activites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($activite->nom); ?></td>
                            <td><?php echo e($activite->debut); ?></td>
                            <td><?php echo e($activite->fin); ?></td>
                            <td><?php echo e($activite->responsable); ?></td>
                            <td><?php echo $activite->rts; ?></td>
                            <td><?php if($activite->fs): ?><a href="<?php echo e(asset('fiche/'.$activite->fs)); ?>">Fiche de collecte</a><?php endif; ?></td>
                           
                            <td>
                                <a href="<?php echo e(route('activite.edit', $activite->id)); ?>" role="button" class="btn btn-info"><i class="fas fa-edit"></i></a>
                                <a href="<?php echo e(route('activite.show', $activite->id)); ?>" role="button" class="btn btn-success"><i class="fas fa-eye"></i></a>
                                <?php echo Form::open(['method' => 'DELETE', 'route'=>['activite.destroy', $activite->id], 'style'=> 'display:inline', 'onclick'=>"if(!confirm('Êtes-vous sûr de vouloir supprimer cet enregistrement ?')) { return false; }"]); ?>

                                <button class="btn btn-danger"><i class="far fa-trash-alt"></i></button>
                                <?php echo Form::close(); ?>




                            </td>

                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>



            </div>

        </div>
    </div>
    <!-- Timelime example  -->
    <div class="row">
      <div class="col-md-12">
        <!-- The time line -->
        <div class="timeline">
            <?php $__currentLoopData = $activites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <!-- timeline time label -->
          <div class="time-label">
            <span class="bg-green"><?php echo e(\Carbon\Carbon::parse($activite->debut)->format('d/m/Y')); ?></span>
          </div>
          <!-- /.timeline-label -->
          <!-- timeline item -->

          <!-- timeline item -->
          <div>
            <i class="fas fa-calendar bg-maroon"></i>

            <div class="timeline-item">
              <span class="time"><i class="fas fa-clock"></i> <?php echo e($activite->responsable); ?></span>

              <h3 class="timeline-header"><a href="#"><?php echo e($activite->nom); ?></a> </h3>

              <div class="timeline-body">
                <?php echo $activite->rts; ?>

              </div>
            </div>
          </div>
          <!-- END timeline item -->
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <div>
            <i class="fas fa-clock bg-gray"></i>
          </div>
        </div>
      </div>
      <!-- /.col -->
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\enda\RFA\plateforme RFA\rfaBackend\resources\views/activite/index.blade.php ENDPATH**/ ?>