<?php

namespace App\Http\Controllers;

use App\Repositories\ProjetRepository;
use App\Repositories\UserRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    protected $userRepository;
    protected $projetRepository;
    public function __construct(UserRepository $userRepository,ProjetRepository $projetRepository){
        $this->userRepository = $userRepository;
        $this->projetRepository = $projetRepository;
    }

    public function index()
    {
        $users = $this->userRepository->getAll();
        return view('user.index',compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $projets = $this->projetRepository->getAll();
        return view('user.add',compact("projets"));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request['password'] = Hash::make($request['password']);
        $users = $this->userRepository->store($request->all());
        return redirect('user');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = $this->userRepository->getById($id);
        return view('user.show',compact('user'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $projets = $this->projetRepository->getAll();
        $user = $this->userRepository->getById($id);
        return view('user.edit',compact('user','projets'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if($request['passwords'])
            $request['password'] = Hash::make($request['passwords']);
        $this->userRepository->update($id, $request->all());
        return redirect('user');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $this->userRepository->destroy($id);
        return redirect('user');
    }

    //function for API

    public function saveUser(Request $request){
        $request->password = bcrypt($request->password);
        $this->userRepository->store($request->all());
        return response()->json('ok');

    }
}
