<?php

namespace App\Http\Controllers;

use App\Repositories\PersonneRepository;
use App\Repositories\QuestionRepository;
use Illuminate\Http\Request;
use stdClass;

class PersonneController extends Controller
{
    protected $personneRepository;
protected $questionRepository;
    public function __construct(PersonneRepository $personneRepository,
    QuestionRepository $questionRepository){
        $this->personneRepository =$personneRepository;
        $this->questionRepository =$questionRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $personnes = $this->personneRepository->getAll();
        return view('personne.index',compact('personnes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $personne = $this->personneRepository->getReponseByPersonne($id);
        $stats = $this->personneRepository->getReponsewithCategorie($id);
        $nbQuestionByCategories = $this->questionRepository->countQuestionByCategorie();
       // dd($stats);
        $somme = 0;
        $tab = array();
        $finals =array();
        foreach ($stats as $key => $value) {
          //  $somme = $somme +$value->somme;
          foreach ($nbQuestionByCategories as $keynb => $nbQuestionByCategorie) {
            if($nbQuestionByCategorie->nomc==$value->nomc){
                $finals[$key]=new stdClass;
                $finals[$key]->nomc = $value->nomc;
                $finals[$key]->somme = $value->somme;
                $finals[$key]->total = $nbQuestionByCategorie->nbquestion*3;
            }

          }
          }
          foreach ($finals as $key => $value) {
            $value->pourcentage = round($value->somme*100/$value->total);
            $tab []=  $value;
          }
        //  dd($tab);
         // dd($somme);
         /* foreach ($stats as $key => $value) {
           $value->pourcentage = round($value->somme*100/$somme);
           $tab []=  $value;
         } */
       //  dd($tab);

        return view('personne.show',compact('personne','tab'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
